/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.cluster;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.elasticsearch.action.admin.cluster.node.reload.NodesReloadSecureSettingsRequest;
import org.elasticsearch.action.admin.cluster.node.reload.NodesReloadSecureSettingsResponse;
import org.elasticsearch.action.admin.cluster.node.reload.TransportNodesReloadSecureSettingsAction;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestRequestFilter;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestActions;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public final class RestReloadSecureSettingsAction
extends BaseRestHandler
implements RestRequestFilter {
    static final ObjectParser<ParsedRequestBody, String> PARSER = new ObjectParser("reload_secure_settings", ParsedRequestBody::new);
    private static final Set<String> FILTERED_FIELDS;

    @Override
    public String getName() {
        return "nodes_reload_action";
    }

    @Override
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/_nodes/reload_secure_settings"), new RestHandler.Route(RestRequest.Method.POST, "/_nodes/{nodeId}/reload_secure_settings"));
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, final NodeClient client) throws IOException {
        final NodesReloadSecureSettingsRequest reloadSecureSettingsRequest = new NodesReloadSecureSettingsRequest();
        reloadSecureSettingsRequest.nodesIds(Strings.splitStringByCommaToArray(request.param("nodeId")));
        reloadSecureSettingsRequest.timeout(request.param("timeout"));
        request.withContentOrSourceParamParserOrNull(parser -> {
            if (parser != null) {
                ParsedRequestBody parsedRequestBody = PARSER.parse((XContentParser)parser, (String)null);
                reloadSecureSettingsRequest.setSecureStorePassword(parsedRequestBody.secureSettingsPassword);
            }
        });
        return new BaseRestHandler.RestChannelConsumer(){

            @Override
            public void accept(RestChannel channel) {
                client.execute(TransportNodesReloadSecureSettingsAction.TYPE, reloadSecureSettingsRequest, new RestBuilderListener<NodesReloadSecureSettingsResponse>(channel){

                    @Override
                    public RestResponse buildResponse(NodesReloadSecureSettingsResponse response, XContentBuilder builder) throws Exception {
                        builder.startObject();
                        RestActions.buildNodesHeader(builder, this.channel.request(), response);
                        builder.field("cluster_name", response.getClusterName().value());
                        response.toXContent(builder, this.channel.request());
                        builder.endObject();
                        return new RestResponse(RestStatus.OK, builder);
                    }
                });
            }

            @Override
            public void close() {
                reloadSecureSettingsRequest.decRef();
            }
        };
    }

    @Override
    public boolean canTripCircuitBreaker() {
        return false;
    }

    @Override
    public Set<String> getFilteredFields() {
        return FILTERED_FIELDS;
    }

    static {
        PARSER.declareString((parsedRequestBody, value) -> {
            parsedRequestBody.secureSettingsPassword = new SecureString(value.toCharArray());
        }, new ParseField("secure_settings_password", new String[0]));
        FILTERED_FIELDS = Set.of("secure_settings_password");
    }

    static final class ParsedRequestBody {
        @Nullable
        SecureString secureSettingsPassword;

        ParsedRequestBody() {
        }
    }
}

