/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.RepositoryVerificationException;
import org.elasticsearch.repositories.VerificationFailure;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;

public class VerifyNodeRepositoryAction {
    private static final Logger logger = LogManager.getLogger(VerifyNodeRepositoryAction.class);
    public static final String ACTION_NAME = "internal:admin/repository/verify";
    private final TransportService transportService;
    private final ClusterService clusterService;
    private final RepositoriesService repositoriesService;

    public VerifyNodeRepositoryAction(TransportService transportService, ClusterService clusterService, RepositoriesService repositoriesService) {
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.repositoriesService = repositoriesService;
        transportService.registerRequestHandler(ACTION_NAME, transportService.getThreadPool().executor("snapshot"), VerifyNodeRepositoryRequest::new, new VerifyNodeRepositoryRequestHandler());
    }

    public void verify(final String repository, String verificationToken, final ActionListener<List<DiscoveryNode>> listener) {
        DiscoveryNodes discoNodes = this.clusterService.state().nodes();
        DiscoveryNode localNode = discoNodes.getLocalNode();
        Collection<DiscoveryNode> masterAndDataNodes = discoNodes.getMasterAndDataNodes().values();
        final ArrayList<DiscoveryNode> nodes = new ArrayList<DiscoveryNode>();
        for (DiscoveryNode node : masterAndDataNodes) {
            if (RepositoriesService.isDedicatedVotingOnlyNode(node.getRoles())) continue;
            nodes.add(node);
        }
        final CopyOnWriteArrayList<VerificationFailure> errors = new CopyOnWriteArrayList<VerificationFailure>();
        final AtomicInteger counter = new AtomicInteger(nodes.size());
        for (final DiscoveryNode node : nodes) {
            if (node.equals(localNode)) {
                try {
                    this.doVerify(repository, verificationToken, localNode);
                }
                catch (Exception e) {
                    logger.warn(() -> "[" + repository + "] failed to verify repository", (Throwable)e);
                    errors.add(new VerificationFailure(node.getId(), e));
                }
                if (counter.decrementAndGet() != 0) continue;
                VerifyNodeRepositoryAction.finishVerification(repository, listener, nodes, errors);
                continue;
            }
            this.transportService.sendRequest(node, ACTION_NAME, new VerifyNodeRepositoryRequest(repository, verificationToken), new TransportResponseHandler.Empty(){

                @Override
                public Executor executor() {
                    return TransportResponseHandler.TRANSPORT_WORKER;
                }

                @Override
                public void handleResponse() {
                    if (counter.decrementAndGet() == 0) {
                        VerifyNodeRepositoryAction.finishVerification(repository, listener, nodes, errors);
                    }
                }

                @Override
                public void handleException(TransportException exp) {
                    errors.add(new VerificationFailure(node.getId(), exp));
                    if (counter.decrementAndGet() == 0) {
                        VerifyNodeRepositoryAction.finishVerification(repository, listener, nodes, errors);
                    }
                }
            });
        }
    }

    private static void finishVerification(String repositoryName, ActionListener<List<DiscoveryNode>> listener, List<DiscoveryNode> nodes, CopyOnWriteArrayList<VerificationFailure> errors) {
        if (!errors.isEmpty()) {
            RepositoryVerificationException e = new RepositoryVerificationException(repositoryName, errors.toString());
            for (VerificationFailure error : errors) {
                e.addSuppressed(error.getCause());
            }
            listener.onFailure(e);
        } else {
            listener.onResponse(nodes);
        }
    }

    private void doVerify(String repositoryName, String verificationToken, DiscoveryNode localNode) {
        Repository repository = this.repositoriesService.repository(repositoryName);
        repository.verify(verificationToken, localNode);
    }

    class VerifyNodeRepositoryRequestHandler
    implements TransportRequestHandler<VerifyNodeRepositoryRequest> {
        VerifyNodeRepositoryRequestHandler() {
        }

        @Override
        public void messageReceived(VerifyNodeRepositoryRequest request, TransportChannel channel, Task task) throws Exception {
            DiscoveryNode localNode = VerifyNodeRepositoryAction.this.clusterService.state().nodes().getLocalNode();
            try {
                VerifyNodeRepositoryAction.this.doVerify(request.repository, request.verificationToken, localNode);
            }
            catch (Exception ex) {
                logger.warn(() -> "[" + request.repository + "] failed to verify repository", (Throwable)ex);
                throw ex;
            }
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }
    }

    public static class VerifyNodeRepositoryRequest
    extends TransportRequest {
        private String repository;
        private String verificationToken;

        public VerifyNodeRepositoryRequest(StreamInput in) throws IOException {
            super(in);
            this.repository = in.readString();
            this.verificationToken = in.readString();
        }

        VerifyNodeRepositoryRequest(String repository, String verificationToken) {
            this.repository = repository;
            this.verificationToken = verificationToken;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.repository);
            out.writeString(this.verificationToken);
        }
    }
}

