/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.plugins.RepositoryPlugin;
import org.elasticsearch.repositories.RepositoriesMetrics;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.fs.FsRepository;
import org.elasticsearch.snapshots.Snapshot;
import org.elasticsearch.snapshots.SnapshotRestoreException;
import org.elasticsearch.telemetry.TelemetryProvider;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.NamedXContentRegistry;

public final class RepositoriesModule {
    private final RepositoriesService repositoriesService;

    public RepositoriesModule(Environment env, List<RepositoryPlugin> repoPlugins, TransportService transportService, ClusterService clusterService, BigArrays bigArrays, NamedXContentRegistry namedXContentRegistry, RecoverySettings recoverySettings, TelemetryProvider telemetryProvider) {
        RepositoriesMetrics repositoriesMetrics = new RepositoriesMetrics(telemetryProvider.getMeterRegistry());
        HashMap<String, Repository.Factory> factories = new HashMap<String, Repository.Factory>();
        factories.put("fs", metadata -> new FsRepository(metadata, env, namedXContentRegistry, clusterService, bigArrays, recoverySettings));
        for (RepositoryPlugin repositoryPlugin : repoPlugins) {
            Map<String, Repository.Factory> map = repositoryPlugin.getRepositories(env, namedXContentRegistry, clusterService, bigArrays, recoverySettings, repositoriesMetrics);
            for (Map.Entry<String, Repository.Factory> entry : map.entrySet()) {
                if (factories.put((String)entry.getKey(), (Repository.Factory)entry.getValue()) == null) continue;
                throw new IllegalArgumentException("Repository type [" + (String)entry.getKey() + "] is already registered");
            }
        }
        HashMap<String, Repository.Factory> internalFactories = new HashMap<String, Repository.Factory>();
        for (RepositoryPlugin repositoryPlugin : repoPlugins) {
            Map<String, Repository.Factory> newRepoTypes = repositoryPlugin.getInternalRepositories(env, namedXContentRegistry, clusterService, recoverySettings);
            for (Map.Entry entry : newRepoTypes.entrySet()) {
                if (internalFactories.put((String)entry.getKey(), (Repository.Factory)entry.getValue()) != null) {
                    throw new IllegalArgumentException("Internal repository type [" + (String)entry.getKey() + "] is already registered");
                }
                if (factories.put((String)entry.getKey(), (Repository.Factory)entry.getValue()) == null) continue;
                throw new IllegalArgumentException("Internal repository type [" + (String)entry.getKey() + "] is already registered as a non-internal repository");
            }
        }
        ArrayList<BiConsumer<Snapshot, IndexVersion>> arrayList = new ArrayList<BiConsumer<Snapshot, IndexVersion>>();
        for (RepositoryPlugin repoPlugin : repoPlugins) {
            BiConsumer<Snapshot, IndexVersion> preRestoreCheck = repoPlugin.addPreRestoreVersionCheck();
            if (preRestoreCheck == null) continue;
            arrayList.add(preRestoreCheck);
        }
        if (arrayList.isEmpty()) {
            arrayList.add((snapshot, version) -> {
                if (version.isLegacyIndexVersion()) {
                    throw new SnapshotRestoreException((Snapshot)snapshot, "the snapshot was created with Elasticsearch version [" + version.toReleaseVersion() + "] which is below the current versions minimum index compatibility version [" + IndexVersions.MINIMUM_COMPATIBLE.toReleaseVersion() + "]");
                }
            });
        }
        Settings settings = env.settings();
        Map<String, Repository.Factory> repositoryTypes = Collections.unmodifiableMap(factories);
        Map<String, Repository.Factory> internalRepositoryTypes = Collections.unmodifiableMap(internalFactories);
        this.repositoriesService = new RepositoriesService(settings, clusterService, transportService, repositoryTypes, internalRepositoryTypes, transportService.getThreadPool(), arrayList);
    }

    public RepositoriesService getRepositoryService() {
        return this.repositoriesService;
    }
}

