/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.phase;

import org.elasticsearch.painless.ir.ClassNode;
import org.elasticsearch.painless.ir.ConstantNode;
import org.elasticsearch.painless.ir.FieldNode;
import org.elasticsearch.painless.phase.IRTreeBaseVisitor;
import org.elasticsearch.painless.symbol.IRDecorations;
import org.elasticsearch.painless.symbol.ScriptScope;

public class DefaultStaticConstantExtractionPhase
extends IRTreeBaseVisitor<ScriptScope> {
    private ClassNode classNode;

    @Override
    public void visitClass(ClassNode irClassNode, ScriptScope scope) {
        this.classNode = irClassNode;
        super.visitClass(irClassNode, scope);
    }

    @Override
    public void visitConstant(ConstantNode irConstantNode, ScriptScope scope) {
        super.visitConstant(irConstantNode, scope);
        Object constant = irConstantNode.getDecorationValue(IRDecorations.IRDConstant.class);
        if (constant instanceof String || constant instanceof Double || constant instanceof Float || constant instanceof Long || constant instanceof Integer || constant instanceof Character || constant instanceof Short || constant instanceof Byte || constant instanceof Boolean) {
            return;
        }
        String fieldName = scope.getNextSyntheticName("constant");
        scope.addStaticConstant(fieldName, constant);
        FieldNode constantField = new FieldNode(irConstantNode.getLocation());
        constantField.attachDecoration(new IRDecorations.IRDModifiers(9));
        constantField.attachDecoration(irConstantNode.getDecoration(IRDecorations.IRDConstant.class));
        Class type = (Class)irConstantNode.getDecorationValue(IRDecorations.IRDExpressionType.class);
        constantField.attachDecoration(new IRDecorations.IRDFieldType(type));
        constantField.attachDecoration(new IRDecorations.IRDName(fieldName));
        this.classNode.addFieldNode(constantField);
        irConstantNode.attachDecoration(new IRDecorations.IRDConstantFieldName(fieldName));
    }
}

