/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless;

import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.settings.Setting;

public final class CompilerSettings {
    public static final Setting<RegexEnabled> REGEX_ENABLED = new Setting<RegexEnabled>("script.painless.regex.enabled", RegexEnabled.LIMITED.value, RegexEnabled::parse, Setting.Property.NodeScope);
    public static final Setting<Integer> REGEX_LIMIT_FACTOR = Setting.intSetting("script.painless.regex.limit-factor", 6, 1, Setting.Property.NodeScope);
    public static final String MAX_LOOP_COUNTER = "max_loop_counter";
    public static final String PICKY = "picky";
    public static final String INITIAL_CALL_SITE_DEPTH = "initialCallSiteDepth";
    private int maxLoopCounter = 1000000;
    private boolean picky = false;
    private int initialCallSiteDepth = 0;
    private int testInject0 = 2;
    private int testInject1 = 4;
    private int testInject2 = 6;
    private RegexEnabled regexesEnabled = RegexEnabled.LIMITED;
    private int regexLimitFactor = 0;

    public int getMaxLoopCounter() {
        return this.maxLoopCounter;
    }

    public void setMaxLoopCounter(int max) {
        this.maxLoopCounter = max;
    }

    public boolean isPicky() {
        return this.picky;
    }

    public void setPicky(boolean picky) {
        this.picky = picky;
    }

    public int getInitialCallSiteDepth() {
        return this.initialCallSiteDepth;
    }

    public void setInitialCallSiteDepth(int depth) {
        this.initialCallSiteDepth = depth;
    }

    public RegexEnabled areRegexesEnabled() {
        return this.regexesEnabled;
    }

    public void setRegexesEnabled(RegexEnabled regexesEnabled) {
        this.regexesEnabled = regexesEnabled;
    }

    public void setRegexLimitFactor(int regexLimitFactor) {
        this.regexLimitFactor = regexLimitFactor;
    }

    public int getAppliedRegexLimitFactor() {
        return switch (this.regexesEnabled) {
            default -> throw new IncompatibleClassChangeError();
            case RegexEnabled.TRUE -> 0;
            case RegexEnabled.FALSE -> -1;
            case RegexEnabled.LIMITED -> this.regexLimitFactor;
        };
    }

    public Map<String, Object> asMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("regex_limit_factor", this.getAppliedRegexLimitFactor());
        map.put("testInject0", this.testInject0);
        map.put("testInject1", this.testInject1);
        map.put("testInject2", this.testInject2);
        return map;
    }

    public static enum RegexEnabled {
        TRUE("true"),
        FALSE("false"),
        LIMITED("limited");

        final String value;

        private RegexEnabled(String value) {
            this.value = value;
        }

        public static RegexEnabled parse(String value) {
            if (RegexEnabled.TRUE.value.equals(value)) {
                return TRUE;
            }
            if (RegexEnabled.FALSE.value.equals(value)) {
                return FALSE;
            }
            if (RegexEnabled.LIMITED.value.equals(value)) {
                return LIMITED;
            }
            throw new IllegalArgumentException("invalid value [" + value + "] must be one of [" + RegexEnabled.TRUE.value + "," + RegexEnabled.FALSE.value + "," + RegexEnabled.LIMITED.value + "]");
        }
    }
}

