/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.util.Objects;
import org.elasticsearch.license.License;
import org.elasticsearch.license.XPackLicenseState;

public abstract class LicensedFeature {
    private final String family;
    private final String name;
    private final License.OperationMode minimumOperationMode;
    private final boolean needsActive;

    protected LicensedFeature(String family, String name, License.OperationMode minimumOperationMode, boolean needsActive) {
        this.family = family;
        this.name = name;
        this.minimumOperationMode = minimumOperationMode;
        this.needsActive = needsActive;
    }

    public String getFamily() {
        return this.family;
    }

    public String getName() {
        return this.name;
    }

    public License.OperationMode getMinimumOperationMode() {
        return this.minimumOperationMode;
    }

    public boolean isNeedsActive() {
        return this.needsActive;
    }

    public static Momentary momentary(String family, String name, License.OperationMode licenseLevel) {
        return new Momentary(family, name, licenseLevel, true);
    }

    public static Persistent persistent(String family, String name, License.OperationMode licenseLevel) {
        return new Persistent(family, name, licenseLevel);
    }

    @Deprecated
    public static Momentary momentaryLenient(String family, String name, License.OperationMode licenseLevel) {
        return new Momentary(family, name, licenseLevel, false);
    }

    public final boolean checkWithoutTracking(XPackLicenseState state) {
        return state.isAllowed(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LicensedFeature that = (LicensedFeature)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public static class Momentary
    extends LicensedFeature {
        private Momentary(String family, String name, License.OperationMode minimumOperationMode, boolean needsActive) {
            super(family, name, minimumOperationMode, needsActive);
        }

        public boolean check(XPackLicenseState state) {
            if (state.isAllowed(this)) {
                state.featureUsed(this);
                return true;
            }
            return false;
        }
    }

    public static class Persistent
    extends LicensedFeature {
        private Persistent(String family, String name, License.OperationMode minimumOperationMode) {
            super(family, name, minimumOperationMode, true);
        }

        public boolean checkAndStartTracking(XPackLicenseState state, String contextName) {
            if (state.isAllowed(this)) {
                this.startTracking(state, contextName);
                return true;
            }
            return false;
        }

        public void startTracking(XPackLicenseState state, String contextName) {
            state.enableUsageTracking(this, contextName);
        }

        public void stopTracking(XPackLicenseState state, String contextName) {
            state.disableUsageTracking(this, contextName);
        }
    }
}

