/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.util.Map;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.common.AbstractStringProcessor;

public final class GsubProcessor
extends AbstractStringProcessor<String> {
    public static final String TYPE = "gsub";
    private static final Logger logger = LogManager.getLogger(GsubProcessor.class);
    private final Pattern pattern;
    private final String replacement;

    GsubProcessor(String tag, String description, String field, Pattern pattern, String replacement, boolean ignoreMissing, String targetField) {
        super(tag, description, ignoreMissing, targetField, field);
        this.pattern = pattern;
        this.replacement = replacement;
    }

    Pattern getPattern() {
        return this.pattern;
    }

    String getReplacement() {
        return this.replacement;
    }

    @Override
    protected String process(String value) {
        try {
            return this.pattern.matcher(value).replaceAll(this.replacement);
        }
        catch (StackOverflowError e) {
            String message = "Caught a StackOverflowError while processing gsub pattern: [" + this.pattern + "]";
            logger.trace(message, (Throwable)e);
            throw new IllegalArgumentException(message);
        }
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public static final class Factory
    extends AbstractStringProcessor.Factory {
        public Factory() {
            super(GsubProcessor.TYPE);
        }

        protected GsubProcessor newProcessor(String processorTag, String description, Map<String, Object> config, String field, boolean ignoreMissing, String targetField) {
            Pattern searchPattern;
            String pattern = ConfigurationUtils.readStringProperty(GsubProcessor.TYPE, processorTag, config, "pattern");
            String replacement = ConfigurationUtils.readStringProperty(GsubProcessor.TYPE, processorTag, config, "replacement");
            try {
                searchPattern = Pattern.compile(pattern);
            }
            catch (Exception e) {
                throw ConfigurationUtils.newConfigurationException(GsubProcessor.TYPE, processorTag, "pattern", "Invalid regex pattern. " + e.getMessage());
            }
            return new GsubProcessor(processorTag, description, field, searchPattern, replacement, ignoreMissing, targetField);
        }
    }
}

