/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;

abstract class AbstractStringProcessor<T>
extends AbstractProcessor {
    private final String field;
    private final boolean ignoreMissing;
    private final String targetField;

    AbstractStringProcessor(String tag, String description, boolean ignoreMissing, String targetField, String field) {
        super(tag, description);
        this.field = field;
        this.ignoreMissing = ignoreMissing;
        this.targetField = targetField;
    }

    public String getField() {
        return this.field;
    }

    boolean isIgnoreMissing() {
        return this.ignoreMissing;
    }

    String getTargetField() {
        return this.targetField;
    }

    @Override
    public final IngestDocument execute(IngestDocument document) {
        Object newValue;
        Object val = document.getFieldValue(this.field, Object.class, this.ignoreMissing);
        if (val == null && this.ignoreMissing) {
            return document;
        }
        if (val == null) {
            throw new IllegalArgumentException("field [" + this.field + "] is null, cannot process it.");
        }
        if (val instanceof List) {
            List list = (List)val;
            ArrayList<T> newList = new ArrayList<T>(list.size());
            for (Object value : list) {
                if (value instanceof String) {
                    String string = (String)value;
                    newList.add(this.process(string));
                    continue;
                }
                throw new IllegalArgumentException("value [" + value + "] of type [" + value.getClass().getName() + "] in list field [" + this.field + "] cannot be cast to [" + String.class.getName() + "]");
            }
            newValue = newList;
        } else if (val instanceof String) {
            String string = (String)val;
            newValue = this.process(string);
        } else {
            throw new IllegalArgumentException("field [" + this.field + "] of type [" + val.getClass().getName() + "] cannot be cast to [" + String.class.getName() + "]");
        }
        document.setFieldValue(this.targetField, newValue);
        return document;
    }

    protected abstract T process(String var1);

    static abstract class Factory
    implements Processor.Factory {
        final String processorType;

        protected Factory(String processorType) {
            this.processorType = processorType;
        }

        @Override
        public AbstractStringProcessor<?> create(Map<String, Processor.Factory> registry, String tag, String description, Map<String, Object> config) throws Exception {
            String field = ConfigurationUtils.readStringProperty(this.processorType, tag, config, "field");
            boolean ignoreMissing = ConfigurationUtils.readBooleanProperty(this.processorType, tag, config, "ignore_missing", false);
            String targetField = ConfigurationUtils.readStringProperty(this.processorType, tag, config, "target_field", field);
            return this.newProcessor(tag, description, config, field, ignoreMissing, targetField);
        }

        protected abstract AbstractStringProcessor<?> newProcessor(String var1, String var2, Map<String, Object> var3, String var4, boolean var5, String var6);
    }
}

