/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.cluster;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.store.AlreadyClosedException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateApplier;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.env.ShardLockObtainFailedException;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.seqno.GlobalCheckpointSyncAction;
import org.elasticsearch.index.seqno.RetentionLeaseSyncer;
import org.elasticsearch.index.shard.GlobalCheckpointSyncer;
import org.elasticsearch.index.shard.IndexEventListener;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.IndexShardClosedException;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.PrimaryReplicaSyncer;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardLongFieldRange;
import org.elasticsearch.index.shard.ShardNotFoundException;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.recovery.PeerRecoverySourceService;
import org.elasticsearch.indices.recovery.PeerRecoveryTargetService;
import org.elasticsearch.indices.recovery.RecoveryFailedException;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.snapshots.SnapshotShardsService;
import org.elasticsearch.threadpool.ThreadPool;

public class IndicesClusterStateService
extends AbstractLifecycleComponent
implements ClusterStateApplier {
    private static final Logger logger = LogManager.getLogger(IndicesClusterStateService.class);
    public static final Setting<TimeValue> SHARD_LOCK_RETRY_INTERVAL_SETTING = Setting.timeSetting("indices.store.shard_lock_retry.interval", TimeValue.timeValueSeconds(1L), Setting.Property.NodeScope);
    public static final Setting<TimeValue> SHARD_LOCK_RETRY_TIMEOUT_SETTING = Setting.timeSetting("indices.store.shard_lock_retry.timeout", TimeValue.timeValueMinutes(1L), Setting.Property.NodeScope);
    final AllocatedIndices<? extends Shard, ? extends AllocatedIndex<? extends Shard>> indicesService;
    private final ClusterService clusterService;
    private final ThreadPool threadPool;
    private final PeerRecoveryTargetService recoveryTargetService;
    private final ShardStateAction shardStateAction;
    private final Settings settings;
    final ConcurrentMap<ShardId, ShardRouting> failedShardsCache = ConcurrentCollections.newConcurrentMap();
    private final Map<ShardId, PendingShardCreation> pendingShardCreations = new HashMap<ShardId, PendingShardCreation>();
    private final RepositoriesService repositoriesService;
    private final FailedShardHandler failedShardHandler = new FailedShardHandler();
    private final List<IndexEventListener> buildInIndexListener;
    private final PrimaryReplicaSyncer primaryReplicaSyncer;
    private final RetentionLeaseSyncer retentionLeaseSyncer;
    private final NodeClient client;
    private final TimeValue shardLockRetryInterval;
    private final TimeValue shardLockRetryTimeout;

    @Inject
    public IndicesClusterStateService(Settings settings, IndicesService indicesService, ClusterService clusterService, ThreadPool threadPool, PeerRecoveryTargetService recoveryTargetService, ShardStateAction shardStateAction, RepositoriesService repositoriesService, SearchService searchService, PeerRecoverySourceService peerRecoverySourceService, SnapshotShardsService snapshotShardsService, PrimaryReplicaSyncer primaryReplicaSyncer, RetentionLeaseSyncer retentionLeaseSyncer, NodeClient client) {
        this(settings, (AllocatedIndices<? extends Shard, ? extends AllocatedIndex<? extends Shard>>)indicesService, clusterService, threadPool, recoveryTargetService, shardStateAction, repositoriesService, searchService, peerRecoverySourceService, snapshotShardsService, primaryReplicaSyncer, retentionLeaseSyncer, client);
    }

    IndicesClusterStateService(Settings settings, AllocatedIndices<? extends Shard, ? extends AllocatedIndex<? extends Shard>> indicesService, ClusterService clusterService, ThreadPool threadPool, PeerRecoveryTargetService recoveryTargetService, ShardStateAction shardStateAction, RepositoriesService repositoriesService, SearchService searchService, PeerRecoverySourceService peerRecoverySourceService, SnapshotShardsService snapshotShardsService, PrimaryReplicaSyncer primaryReplicaSyncer, RetentionLeaseSyncer retentionLeaseSyncer, NodeClient client) {
        this.settings = settings;
        this.buildInIndexListener = Arrays.asList(peerRecoverySourceService, recoveryTargetService, searchService, snapshotShardsService);
        this.indicesService = indicesService;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.recoveryTargetService = recoveryTargetService;
        this.shardStateAction = shardStateAction;
        this.repositoriesService = repositoriesService;
        this.primaryReplicaSyncer = primaryReplicaSyncer;
        this.retentionLeaseSyncer = retentionLeaseSyncer;
        this.client = client;
        this.shardLockRetryInterval = SHARD_LOCK_RETRY_INTERVAL_SETTING.get(settings);
        this.shardLockRetryTimeout = SHARD_LOCK_RETRY_TIMEOUT_SETTING.get(settings);
    }

    @Override
    protected void doStart() {
        if (DiscoveryNode.canContainData(this.settings)) {
            this.clusterService.addHighPriorityApplier(this);
        }
    }

    @Override
    protected void doStop() {
        if (DiscoveryNode.canContainData(this.settings)) {
            this.clusterService.removeApplier(this);
        }
    }

    @Override
    protected void doClose() {
    }

    @Override
    public synchronized void applyClusterState(ClusterChangedEvent event) {
        if (!this.lifecycle.started()) {
            return;
        }
        ClusterState state = event.state();
        DiscoveryNode currentMaster = state.nodes().getMasterNode();
        if (currentMaster != null && !currentMaster.equals(event.previousState().nodes().getMasterNode())) {
            this.shardStateAction.clearRemoteShardRequestDeduplicator();
        }
        if (state.blocks().disableStatePersistence()) {
            for (AllocatedIndex indexService : this.indicesService) {
                this.indicesService.removeIndex(indexService.getIndexSettings().getIndex(), AllocatedIndices.IndexRemovalReason.NO_LONGER_ASSIGNED, "cleaning index (disabled block persistence)");
            }
            return;
        }
        this.updateFailedShardsCache(state);
        this.deleteIndices(event);
        this.removeIndicesAndShards(event);
        this.updateIndices(event);
        this.createIndicesAndUpdateShards(state);
    }

    private void updateFailedShardsCache(ClusterState state) {
        RoutingNode localRoutingNode = state.getRoutingNodes().node(state.nodes().getLocalNodeId());
        if (localRoutingNode == null) {
            this.failedShardsCache.clear();
            return;
        }
        DiscoveryNode masterNode = state.nodes().getMasterNode();
        Iterator iterator = this.failedShardsCache.entrySet().iterator();
        while (iterator.hasNext()) {
            ShardRouting failedShardRouting = (ShardRouting)iterator.next().getValue();
            ShardRouting matchedRouting = localRoutingNode.getByShardId(failedShardRouting.shardId());
            if (matchedRouting == null || !matchedRouting.isSameAllocation(failedShardRouting)) {
                iterator.remove();
                continue;
            }
            if (masterNode == null) continue;
            String message = "master " + masterNode + " has not removed previously failed shard. resending shard failure";
            logger.trace("[{}] re-sending failed shard [{}], reason [{}]", (Object)matchedRouting.shardId(), (Object)matchedRouting, (Object)message);
            this.shardStateAction.localShardFailed(matchedRouting, message, null, ActionListener.noop(), state);
        }
    }

    protected void updateGlobalCheckpointForShard(ShardId shardId) {
        ThreadContext threadContext = this.threadPool.getThreadContext();
        try (ThreadContext.StoredContext ignore = threadContext.stashContext();){
            threadContext.markAsSystemContext();
            this.client.executeLocally(GlobalCheckpointSyncAction.TYPE, new GlobalCheckpointSyncAction.Request(shardId), ActionListener.wrap(r -> {}, e -> {
                if (ExceptionsHelper.unwrap(e, AlreadyClosedException.class, IndexShardClosedException.class) == null) {
                    logger.info(() -> Strings.format("%s global checkpoint sync failed", shardId), (Throwable)e);
                }
            }));
        }
    }

    private void deleteIndices(ClusterChangedEvent event) {
        ClusterState previousState = event.previousState();
        ClusterState state = event.state();
        String localNodeId = state.nodes().getLocalNodeId();
        assert (localNodeId != null);
        for (final Index index : event.indicesDeleted()) {
            IndexSettings indexSettings;
            AllocatedIndex<? extends Shard> indexService;
            if (logger.isDebugEnabled()) {
                logger.debug("[{}] cleaning index, no longer part of the metadata", (Object)index);
            }
            if ((indexService = this.indicesService.indexService(index)) != null) {
                indexSettings = indexService.getIndexSettings();
                this.indicesService.removeIndex(index, AllocatedIndices.IndexRemovalReason.DELETED, "index no longer part of the metadata");
            } else if (previousState.metadata().hasIndex(index)) {
                metadata = previousState.metadata().index(index);
                indexSettings = new IndexSettings(metadata, this.settings);
                this.indicesService.deleteUnassignedIndex("deleted index was not assigned to local node", metadata, state);
            } else {
                assert (state.metadata().indexGraveyard().containsIndex(index) || previousState.blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK));
                metadata = this.indicesService.verifyIndexIsDeleted(index, event.state());
                indexSettings = metadata != null ? new IndexSettings(metadata, this.settings) : null;
            }
            if (indexSettings == null) continue;
            this.threadPool.generic().execute(new AbstractRunnable(){

                @Override
                public void onFailure(Exception e) {
                    logger.warn(() -> "[" + index + "] failed to complete pending deletion for index", (Throwable)e);
                }

                @Override
                protected void doRun() throws Exception {
                    TimeValue timeout = TimeValue.timeValueMinutes(30L);
                    try {
                        IndicesClusterStateService.this.indicesService.processPendingDeletes(index, indexSettings, timeout);
                    }
                    catch (ShardLockObtainFailedException exc) {
                        logger.warn("[{}] failed to lock all shards for index - timed out after [{}]]", (Object)index, (Object)timeout);
                    }
                    catch (InterruptedException e) {
                        logger.warn("[{}] failed to lock all shards for index - interrupted", (Object)index);
                    }
                }
            });
        }
    }

    private void removeIndicesAndShards(ClusterChangedEvent event) {
        ClusterState state = event.state();
        String localNodeId = state.nodes().getLocalNodeId();
        assert (localNodeId != null);
        RoutingNode localRoutingNode = state.getRoutingNodes().node(localNodeId);
        for (AllocatedIndex indexService : this.indicesService) {
            Index index = indexService.getIndexSettings().getIndex();
            IndexMetadata indexMetadata = state.metadata().index(index);
            IndexMetadata existingMetadata = indexService.getIndexSettings().getIndexMetadata();
            AllocatedIndices.IndexRemovalReason reason = null;
            if (indexMetadata != null && indexMetadata.getState() != existingMetadata.getState()) {
                reason = indexMetadata.getState() == IndexMetadata.State.CLOSE ? AllocatedIndices.IndexRemovalReason.CLOSED : AllocatedIndices.IndexRemovalReason.REOPENED;
            } else if (localRoutingNode == null || !localRoutingNode.hasIndex(index)) {
                assert (indexMetadata != null || event.isNewCluster()) : "index " + index + " does not exist in the cluster state, it should either have been deleted or the cluster must be new";
                AllocatedIndices.IndexRemovalReason indexRemovalReason = reason = indexMetadata != null && indexMetadata.getState() == IndexMetadata.State.CLOSE ? AllocatedIndices.IndexRemovalReason.CLOSED : AllocatedIndices.IndexRemovalReason.NO_LONGER_ASSIGNED;
            }
            if (reason != null) {
                logger.debug("{} removing index ({})", (Object)index, (Object)reason);
                this.indicesService.removeIndex(index, reason, "removing index (" + reason + ")");
                continue;
            }
            for (Shard shard : indexService) {
                ShardRouting currentRoutingEntry = shard.routingEntry();
                ShardId shardId = currentRoutingEntry.shardId();
                ShardRouting newShardRouting = localRoutingNode.getByShardId(shardId);
                if (newShardRouting == null) {
                    logger.debug("{} removing shard (not allocated)", (Object)shardId);
                    indexService.removeShard(shardId.id(), "removing shard (not allocated)");
                    continue;
                }
                if (!newShardRouting.isSameAllocation(currentRoutingEntry)) {
                    logger.debug("{} removing shard (stale allocation id, stale {}, new {})", (Object)shardId, (Object)currentRoutingEntry, (Object)newShardRouting);
                    indexService.removeShard(shardId.id(), "removing shard (stale copy)");
                    continue;
                }
                if (newShardRouting.initializing() && currentRoutingEntry.active()) {
                    logger.debug("{} removing shard (not active, current {}, new {})", (Object)shardId, (Object)currentRoutingEntry, (Object)newShardRouting);
                    indexService.removeShard(shardId.id(), "removing shard (stale copy)");
                    continue;
                }
                if (!newShardRouting.primary() || currentRoutingEntry.primary() || !newShardRouting.initializing()) continue;
                assert (currentRoutingEntry.initializing()) : currentRoutingEntry;
                logger.debug("{} removing shard (not active, current {}, new {})", (Object)shardId, (Object)currentRoutingEntry, (Object)newShardRouting);
                indexService.removeShard(shardId.id(), "removing shard (stale copy)");
            }
        }
    }

    private void createIndicesAndUpdateShards(ClusterState state) {
        AllocatedIndex<? extends Shard> indexService;
        RoutingNode localRoutingNode = state.getRoutingNodes().node(state.nodes().getLocalNodeId());
        if (localRoutingNode == null) {
            return;
        }
        HashMap<Index, List> indicesToCreate = new HashMap<Index, List>();
        for (ShardRouting shardRouting : localRoutingNode) {
            ShardId shardId = shardRouting.shardId();
            if (this.failedShardsCache.containsKey(shardId)) continue;
            Index index = shardRouting.index();
            indexService = this.indicesService.indexService(index);
            if (!(shardRouting.initializing() || indexService != null && indexService.getShardOrNull(shardId.id()) != null)) {
                this.sendFailShard(shardRouting, "master marked shard as active, but shard has not been created, mark shard as failed", null, state);
                continue;
            }
            if (indexService == null) {
                indicesToCreate.computeIfAbsent(index, k -> new ArrayList()).add(shardRouting);
                continue;
            }
            this.createOrUpdateShard(state, shardRouting, indexService);
        }
        for (Map.Entry entry : indicesToCreate.entrySet()) {
            Index index = (Index)entry.getKey();
            IndexMetadata indexMetadata = state.metadata().index(index);
            logger.debug("[{}] creating index", (Object)index);
            indexService = null;
            try {
                indexService = this.indicesService.createIndex(indexMetadata, this.buildInIndexListener, true);
                indexService.updateMapping(null, indexMetadata);
            }
            catch (Exception e) {
                String failShardReason;
                if (indexService == null) {
                    failShardReason = "failed to create index";
                } else {
                    failShardReason = "failed to update mapping for index";
                    this.indicesService.removeIndex(index, AllocatedIndices.IndexRemovalReason.FAILURE, "removing index (mapping update failed)");
                }
                for (ShardRouting shardRouting : (List)entry.getValue()) {
                    this.sendFailShard(shardRouting, failShardReason, e, state);
                }
                continue;
            }
            for (ShardRouting shardRouting : (List)entry.getValue()) {
                this.createOrUpdateShard(state, shardRouting, indexService);
            }
        }
    }

    private void createOrUpdateShard(ClusterState state, ShardRouting shardRouting, AllocatedIndex<? extends Shard> indexService) {
        Shard shard = indexService.getShardOrNull(shardRouting.shardId().id());
        if (shard == null) {
            assert (shardRouting.initializing()) : shardRouting + " should have been removed by failMissingShards";
            this.createShard(shardRouting, state);
        } else {
            this.updateShard(shardRouting, shard, state);
        }
    }

    private void updateIndices(ClusterChangedEvent event) {
        if (!event.metadataChanged()) {
            return;
        }
        ClusterState state = event.state();
        for (AllocatedIndex indexService : this.indicesService) {
            IndexMetadata currentIndexMetadata = indexService.getIndexSettings().getIndexMetadata();
            Index index = indexService.getIndexSettings().getIndex();
            IndexMetadata newIndexMetadata = state.metadata().index(index);
            assert (newIndexMetadata != null) : "index " + index + " should have been removed by deleteIndices";
            if (!ClusterChangedEvent.indexMetadataChanged(currentIndexMetadata, newIndexMetadata)) continue;
            String reason = null;
            try {
                reason = "metadata update failed";
                try {
                    indexService.updateMetadata(currentIndexMetadata, newIndexMetadata);
                }
                catch (Exception e) {
                    assert (false) : e;
                    throw e;
                }
                reason = "mapping update failed";
                indexService.updateMapping(currentIndexMetadata, newIndexMetadata);
            }
            catch (Exception e) {
                this.indicesService.removeIndex(index, AllocatedIndices.IndexRemovalReason.FAILURE, "removing index (" + reason + ")");
                RoutingNode localRoutingNode = state.getRoutingNodes().node(state.nodes().getLocalNodeId());
                if (localRoutingNode == null) continue;
                for (ShardRouting shardRouting : localRoutingNode) {
                    if (!shardRouting.index().equals(index) || this.failedShardsCache.containsKey(shardRouting.shardId())) continue;
                    this.sendFailShard(shardRouting, "failed to update index (" + reason + ")", e, state);
                }
            }
        }
    }

    private void createShard(final ShardRouting shardRouting, final ClusterState state) {
        assert (shardRouting.initializing()) : "only allow shard creation for initializing shard but was " + shardRouting;
        final ShardId shardId = shardRouting.shardId();
        try {
            DiscoveryNode sourceNode;
            if (shardRouting.recoverySource().getType() == RecoverySource.Type.PEER) {
                sourceNode = IndicesClusterStateService.findSourceNodeForPeerRecovery(state.routingTable(), state.nodes(), shardRouting);
                if (sourceNode == null) {
                    logger.trace("ignoring initializing shard {} - no source node can be found.", (Object)shardId);
                    return;
                }
            } else {
                sourceNode = null;
            }
            final long primaryTerm = state.metadata().index(shardRouting.index()).primaryTerm(shardRouting.id());
            PendingShardCreation pendingShardCreation = this.createOrRefreshPendingShardCreation(shardId, state.stateUUID());
            this.createShardWhenLockAvailable(shardRouting, state, sourceNode, primaryTerm, 0, 0L, ActionListener.runBefore(new ActionListener<Boolean>(){

                @Override
                public void onResponse(Boolean success) {
                    if (Boolean.TRUE.equals(success)) {
                        logger.debug("{} created shard with primary term [{}]", (Object)shardId, (Object)primaryTerm);
                    } else {
                        logger.debug("{} gave up while trying to create shard", (Object)shardId);
                    }
                }

                @Override
                public void onFailure(Exception e) {
                    IndicesClusterStateService.this.failAndRemoveShard(shardRouting, true, "failed to create shard", e, state);
                }
            }, () -> {
                assert (ThreadPool.assertCurrentThreadPool("clusterApplierService#updateTask"));
                this.pendingShardCreations.remove(shardId, pendingShardCreation);
            }));
        }
        catch (Exception e) {
            assert (this.pendingShardCreations.get(shardId) == null || !this.pendingShardCreations.get(shardId).clusterStateUUID().equals(state.stateUUID()));
            this.failAndRemoveShard(shardRouting, true, "failed to create shard", e, state);
        }
    }

    private PendingShardCreation createOrRefreshPendingShardCreation(ShardId shardId, String clusterStateUUID) {
        assert (ThreadPool.assertCurrentThreadPool("clusterApplierService#updateTask"));
        PendingShardCreation currentPendingShardCreation = this.pendingShardCreations.get(shardId);
        PendingShardCreation newPendingShardCreation = new PendingShardCreation(clusterStateUUID, currentPendingShardCreation == null ? this.threadPool.relativeTimeInMillis() : currentPendingShardCreation.startTimeMillis());
        this.pendingShardCreations.put(shardId, newPendingShardCreation);
        return newPendingShardCreation;
    }

    private void createShardWhenLockAvailable(ShardRouting shardRouting, ClusterState originalState, DiscoveryNode sourceNode, long primaryTerm, int iteration, long delayMillis, ActionListener<Boolean> listener) {
        try {
            logger.debug("{} creating shard with primary term [{}], iteration [{}]", (Object)shardRouting.shardId(), (Object)primaryTerm, (Object)iteration);
            this.indicesService.createShard(shardRouting, this.recoveryTargetService, new RecoveryListener(shardRouting, primaryTerm), this.repositoriesService, this.failedShardHandler, this::updateGlobalCheckpointForShard, this.retentionLeaseSyncer, originalState.nodes().getLocalNode(), sourceNode, originalState.version());
            listener.onResponse(true);
        }
        catch (ShardLockObtainFailedException e) {
            if (e.getCause() instanceof InterruptedException || Thread.currentThread().isInterrupted()) {
                logger.warn(Strings.format("interrupted while creating shard [%s]", shardRouting), (Throwable)e);
                listener.onFailure(e);
                return;
            }
            logger.log((iteration + 25) % 30 == 0 ? Level.WARN : Level.DEBUG, "shard lock for [{}] has been unavailable for at least [{}/{}ms], attempting to create shard while applying cluster state [version={},uuid={}], will retry in [{}]: [{}]", (Object)shardRouting, (Object)TimeValue.timeValueMillis(delayMillis), (Object)delayMillis, (Object)originalState.version(), (Object)originalState.stateUUID(), (Object)this.shardLockRetryInterval, (Object)e.getMessage());
            this.threadPool.scheduleUnlessShuttingDown(this.shardLockRetryInterval, EsExecutors.DIRECT_EXECUTOR_SERVICE, () -> this.clusterService.getClusterApplierService().runOnApplierThread("create shard " + shardRouting, Priority.NORMAL, currentState -> {
                assert (ThreadPool.assertCurrentThreadPool("clusterApplierService#updateTask"));
                PendingShardCreation pendingShardCreation = this.pendingShardCreations.get(shardRouting.shardId());
                if (pendingShardCreation == null) {
                    listener.onResponse(false);
                    return;
                }
                if (!originalState.stateUUID().equals(currentState.stateUUID())) {
                    logger.debug("cluster state updated from version [{}/{}] to version [{}/{}] before creation of shard {}", (Object)originalState.version(), (Object)originalState.stateUUID(), (Object)currentState.version(), (Object)currentState.stateUUID(), (Object)shardRouting.shardId());
                    listener.onResponse(false);
                    return;
                }
                assert (pendingShardCreation.clusterStateUUID().equals(currentState.stateUUID()));
                long newDelayMillis = this.threadPool.relativeTimeInMillis() - pendingShardCreation.startTimeMillis();
                if (newDelayMillis > this.shardLockRetryTimeout.millis()) {
                    logger.warn("timed out after [{}={}/{}ms] while waiting to acquire shard lock for {}", (Object)SHARD_LOCK_RETRY_TIMEOUT_SETTING.getKey(), (Object)this.shardLockRetryTimeout, (Object)this.shardLockRetryTimeout.millis(), (Object)shardRouting);
                    listener.onFailure(new ElasticsearchTimeoutException("timed out while waiting to acquire shard lock for " + shardRouting, new Object[0]));
                    return;
                }
                AllocatedIndex<? extends Shard> indexService = this.indicesService.indexService(shardRouting.index());
                if (indexService == null) {
                    String message = "index service unexpectedly not found for " + shardRouting;
                    assert (false) : message;
                    listener.onFailure(new ElasticsearchException(message, new Object[0]));
                    return;
                }
                if (indexService.getShardOrNull(shardRouting.shardId().id()) != null) {
                    String message = "index shard unexpectedly found for " + shardRouting;
                    assert (false) : message;
                    listener.onFailure(new ElasticsearchException(message, new Object[0]));
                    return;
                }
                this.createShardWhenLockAvailable(shardRouting, originalState, sourceNode, primaryTerm, iteration + 1, newDelayMillis, listener);
            }, ActionListener.noop()));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private void updateShard(ShardRouting shardRouting, Shard shard, ClusterState clusterState) {
        long primaryTerm;
        ShardRouting currentRoutingEntry = shard.routingEntry();
        assert (currentRoutingEntry.isSameAllocation(shardRouting)) : "local shard has a different allocation id but wasn't cleaned by removeShards. cluster state: " + shardRouting + " local: " + currentRoutingEntry;
        try {
            IndexMetadata indexMetadata = clusterState.metadata().index(shard.shardId().getIndex());
            primaryTerm = indexMetadata.primaryTerm(shard.shardId().id());
            Set<String> inSyncIds = indexMetadata.inSyncAllocationIds(shard.shardId().id());
            IndexShardRoutingTable indexShardRoutingTable = clusterState.routingTable().shardRoutingTable(shardRouting.shardId());
            shard.updateShardState(shardRouting, primaryTerm, this.primaryReplicaSyncer::resync, clusterState.version(), inSyncIds, indexShardRoutingTable);
        }
        catch (Exception e) {
            this.failAndRemoveShard(shardRouting, true, "failed updating shard routing entry", e, clusterState);
            return;
        }
        IndexShardState state = shard.state();
        if (shardRouting.initializing() && (state == IndexShardState.STARTED || state == IndexShardState.POST_RECOVERY)) {
            if (logger.isTraceEnabled()) {
                logger.trace("{} master marked shard as initializing, but shard has state [{}], resending shard started to {}", (Object)shardRouting.shardId(), (Object)state, (Object)clusterState.nodes().getMasterNode());
            }
            if (clusterState.nodes().getMasterNode() != null) {
                this.shardStateAction.shardStarted(shardRouting, primaryTerm, "master " + clusterState.nodes().getMasterNode() + " marked shard as initializing, but shard state is [" + state + "], mark shard as started", shard.getTimestampRange(), ActionListener.noop(), clusterState);
            }
        }
    }

    private static DiscoveryNode findSourceNodeForPeerRecovery(RoutingTable routingTable, DiscoveryNodes nodes, ShardRouting shardRouting) {
        DiscoveryNode sourceNode = null;
        if (!shardRouting.primary()) {
            ShardRouting primary = routingTable.shardRoutingTable(shardRouting.shardId()).primaryShard();
            if (primary.active()) {
                sourceNode = nodes.get(primary.currentNodeId());
                if (sourceNode == null) {
                    logger.trace("can't find replica source node because primary shard {} is assigned to an unknown node.", (Object)primary);
                }
            } else {
                logger.trace("can't find replica source node because primary shard {} is not active.", (Object)primary);
            }
        } else if (shardRouting.relocatingNodeId() != null) {
            sourceNode = nodes.get(shardRouting.relocatingNodeId());
            if (sourceNode == null) {
                logger.trace("can't find relocation source node for shard {} because it is assigned to an unknown node [{}].", (Object)shardRouting.shardId(), (Object)shardRouting.relocatingNodeId());
            }
        } else {
            throw new IllegalStateException("trying to find source node for peer recovery when routing state means no peer recovery: " + shardRouting);
        }
        return sourceNode;
    }

    synchronized void handleRecoveryFailure(ShardRouting shardRouting, boolean sendShardFailure, Exception failure) {
        this.failAndRemoveShard(shardRouting, sendShardFailure, "failed recovery", failure, this.clusterService.state());
    }

    private void failAndRemoveShard(ShardRouting shardRouting, boolean sendShardFailure, String message, @Nullable Exception failure, ClusterState state) {
        try {
            Shard shard;
            AllocatedIndex<? extends Shard> indexService = this.indicesService.indexService(shardRouting.shardId().getIndex());
            if (indexService != null && (shard = indexService.getShardOrNull(shardRouting.shardId().id())) != null && shard.routingEntry().isSameAllocation(shardRouting)) {
                indexService.removeShard(shardRouting.shardId().id(), message);
            }
        }
        catch (ShardNotFoundException indexService) {
        }
        catch (Exception inner) {
            inner.addSuppressed(failure);
            logger.warn(() -> Strings.format("[%s][%s] failed to remove shard after failure ([%s])", shardRouting.getIndexName(), shardRouting.getId(), message), (Throwable)inner);
        }
        if (sendShardFailure) {
            this.sendFailShard(shardRouting, message, failure, state);
        }
    }

    private void sendFailShard(ShardRouting shardRouting, String message, @Nullable Exception failure, ClusterState state) {
        try {
            logger.warn(() -> Strings.format("%s marking and sending shard failed due to [%s]", shardRouting.shardId(), message), (Throwable)failure);
            this.failedShardsCache.put(shardRouting.shardId(), shardRouting);
            this.shardStateAction.localShardFailed(shardRouting, message, failure, ActionListener.noop(), state);
        }
        catch (Exception inner) {
            if (failure != null) {
                inner.addSuppressed(failure);
            }
            logger.warn(() -> Strings.format("[%s][%s] failed to mark shard as failed (because of [%s])", shardRouting.getIndexName(), shardRouting.getId(), message), (Throwable)inner);
        }
    }

    public static interface AllocatedIndices<T extends Shard, U extends AllocatedIndex<T>>
    extends Iterable<U> {
        public U createIndex(IndexMetadata var1, List<IndexEventListener> var2, boolean var3) throws IOException;

        public IndexMetadata verifyIndexIsDeleted(Index var1, ClusterState var2);

        public void deleteUnassignedIndex(String var1, IndexMetadata var2, ClusterState var3);

        public void removeIndex(Index var1, IndexRemovalReason var2, String var3);

        @Nullable
        public U indexService(Index var1);

        public void createShard(ShardRouting var1, PeerRecoveryTargetService var2, PeerRecoveryTargetService.RecoveryListener var3, RepositoriesService var4, Consumer<IndexShard.ShardFailure> var5, GlobalCheckpointSyncer var6, RetentionLeaseSyncer var7, DiscoveryNode var8, @Nullable DiscoveryNode var9, long var10) throws IOException;

        default public T getShardOrNull(ShardId shardId) {
            U indexRef = this.indexService(shardId.getIndex());
            if (indexRef != null) {
                return indexRef.getShardOrNull(shardId.id());
            }
            return null;
        }

        public void processPendingDeletes(Index var1, IndexSettings var2, TimeValue var3) throws IOException, InterruptedException, ShardLockObtainFailedException;

        public static enum IndexRemovalReason {
            NO_LONGER_ASSIGNED,
            DELETED,
            CLOSED,
            FAILURE,
            REOPENED,
            SHUTDOWN;

        }
    }

    private class FailedShardHandler
    implements Consumer<IndexShard.ShardFailure> {
        private FailedShardHandler() {
        }

        @Override
        public void accept(IndexShard.ShardFailure shardFailure) {
            ShardRouting shardRouting = shardFailure.routing();
            IndicesClusterStateService.this.threadPool.generic().execute(() -> {
                IndicesClusterStateService indicesClusterStateService = IndicesClusterStateService.this;
                synchronized (indicesClusterStateService) {
                    IndicesClusterStateService.this.failAndRemoveShard(shardRouting, true, "shard failure, reason [" + shardFailure.reason() + "]", shardFailure.cause(), IndicesClusterStateService.this.clusterService.state());
                }
            });
        }
    }

    public static interface AllocatedIndex<T extends Shard>
    extends Iterable<T> {
        public IndexSettings getIndexSettings();

        public void updateMetadata(IndexMetadata var1, IndexMetadata var2);

        public void updateMapping(IndexMetadata var1, IndexMetadata var2) throws IOException;

        @Nullable
        public T getShardOrNull(int var1);

        public void removeShard(int var1, String var2);
    }

    public static interface Shard {
        public ShardId shardId();

        public ShardRouting routingEntry();

        public IndexShardState state();

        public RecoveryState recoveryState();

        @Nullable
        public ShardLongFieldRange getTimestampRange();

        public void updateShardState(ShardRouting var1, long var2, BiConsumer<IndexShard, ActionListener<PrimaryReplicaSyncer.ResyncTask>> var4, long var5, Set<String> var7, IndexShardRoutingTable var8) throws IOException;
    }

    private record PendingShardCreation(String clusterStateUUID, long startTimeMillis) {
    }

    private class RecoveryListener
    implements PeerRecoveryTargetService.RecoveryListener {
        private final ShardRouting shardRouting;
        private final long primaryTerm;

        private RecoveryListener(ShardRouting shardRouting, long primaryTerm) {
            this.shardRouting = shardRouting;
            this.primaryTerm = primaryTerm;
        }

        @Override
        public void onRecoveryDone(RecoveryState state, ShardLongFieldRange timestampMillisFieldRange) {
            IndicesClusterStateService.this.shardStateAction.shardStarted(this.shardRouting, this.primaryTerm, "after " + state.getRecoverySource(), timestampMillisFieldRange, ActionListener.noop());
        }

        @Override
        public void onRecoveryFailure(RecoveryFailedException e, boolean sendShardFailure) {
            IndicesClusterStateService.this.handleRecoveryFailure(this.shardRouting, sendShardFailure, e);
        }
    }
}

