/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.snapshots.blobstore;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.snapshots.blobstore.BlobStoreIndexShardSnapshot;
import org.elasticsearch.index.snapshots.blobstore.SnapshotFiles;
import org.elasticsearch.index.store.StoreFileMetadata;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class BlobStoreIndexShardSnapshots
implements Iterable<SnapshotFiles>,
ToXContentFragment {
    public static final BlobStoreIndexShardSnapshots EMPTY = new BlobStoreIndexShardSnapshots(Map.of(), List.of());
    private final List<SnapshotFiles> shardSnapshots;
    private final Map<String, BlobStoreIndexShardSnapshot.FileInfo> files;
    private Map<String, Collection<BlobStoreIndexShardSnapshot.FileInfo>> physicalFiles;

    private BlobStoreIndexShardSnapshots(Map<String, BlobStoreIndexShardSnapshot.FileInfo> files, List<SnapshotFiles> shardSnapshots) {
        this.shardSnapshots = List.copyOf(shardSnapshots);
        this.files = files;
    }

    public BlobStoreIndexShardSnapshots withRetainedSnapshots(Set<SnapshotId> retainedSnapshots) {
        if (retainedSnapshots.isEmpty()) {
            return EMPTY;
        }
        Set survivingSnapshotNames = retainedSnapshots.stream().map(SnapshotId::getName).collect(Collectors.toSet());
        ArrayList<SnapshotFiles> updatedSnapshots = new ArrayList<SnapshotFiles>(survivingSnapshotNames.size());
        HashMap<String, BlobStoreIndexShardSnapshot.FileInfo> newFiles = new HashMap<String, BlobStoreIndexShardSnapshot.FileInfo>();
        for (SnapshotFiles snapshot : this.shardSnapshots) {
            if (!survivingSnapshotNames.contains(snapshot.snapshot())) continue;
            updatedSnapshots.add(snapshot);
            for (BlobStoreIndexShardSnapshot.FileInfo fileInfo : snapshot.indexFiles()) {
                BlobStoreIndexShardSnapshot.FileInfo oldFile = newFiles.put(fileInfo.name(), fileInfo);
                assert (oldFile == null || oldFile.isSame(fileInfo));
            }
        }
        return new BlobStoreIndexShardSnapshots(newFiles, updatedSnapshots);
    }

    public BlobStoreIndexShardSnapshots withAddedSnapshot(SnapshotFiles snapshotFiles) {
        Map<String, BlobStoreIndexShardSnapshot.FileInfo> updatedFiles = null;
        for (BlobStoreIndexShardSnapshot.FileInfo fileInfo : snapshotFiles.indexFiles()) {
            BlobStoreIndexShardSnapshot.FileInfo known = this.files.get(fileInfo.name());
            if (known == null) {
                if (updatedFiles == null) {
                    updatedFiles = new HashMap<String, BlobStoreIndexShardSnapshot.FileInfo>(this.files);
                }
                updatedFiles.put(fileInfo.name(), fileInfo);
                continue;
            }
            assert (fileInfo.isSame(known));
        }
        return new BlobStoreIndexShardSnapshots(updatedFiles == null ? this.files : updatedFiles, CollectionUtils.appendToCopyNoNullElements(this.shardSnapshots, snapshotFiles));
    }

    public BlobStoreIndexShardSnapshots withClone(String source, String target) {
        SnapshotFiles sourceFiles = null;
        for (SnapshotFiles shardSnapshot : this.shardSnapshots) {
            if (!shardSnapshot.snapshot().equals(source)) continue;
            sourceFiles = shardSnapshot;
            break;
        }
        if (sourceFiles == null) {
            throw new IllegalArgumentException("unknown source [" + source + "]");
        }
        return new BlobStoreIndexShardSnapshots(this.files, CollectionUtils.appendToCopyNoNullElements(this.shardSnapshots, sourceFiles.withSnapshotName(target)));
    }

    public List<SnapshotFiles> snapshots() {
        return this.shardSnapshots;
    }

    public BlobStoreIndexShardSnapshot.FileInfo findPhysicalIndexFile(StoreFileMetadata storeFileMetadata) {
        Collection<BlobStoreIndexShardSnapshot.FileInfo> found;
        Map<String, Collection<BlobStoreIndexShardSnapshot.FileInfo>> p = this.physicalFiles;
        if (p == null) {
            p = new HashMap<String, Collection<BlobStoreIndexShardSnapshot.FileInfo>>();
            for (SnapshotFiles snapshot : this.shardSnapshots) {
                for (BlobStoreIndexShardSnapshot.FileInfo fileInfo : snapshot.indexFiles()) {
                    p.computeIfAbsent(fileInfo.physicalName(), k -> Collections.newSetFromMap(new IdentityHashMap())).add(this.files.get(fileInfo.name()));
                }
            }
            this.physicalFiles = p;
        }
        if ((found = p.get(storeFileMetadata.name())) == null) {
            return null;
        }
        for (BlobStoreIndexShardSnapshot.FileInfo fileInfo : found) {
            if (!fileInfo.isSame(storeFileMetadata)) continue;
            return fileInfo;
        }
        return null;
    }

    public BlobStoreIndexShardSnapshot.FileInfo findNameFile(String name) {
        return this.files.get(name);
    }

    @Override
    public Iterator<SnapshotFiles> iterator() {
        return this.shardSnapshots.iterator();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray("files");
        for (Map.Entry<String, BlobStoreIndexShardSnapshot.FileInfo> entry : this.files.entrySet()) {
            BlobStoreIndexShardSnapshot.FileInfo.toXContent(entry.getValue(), builder, params);
        }
        builder.endArray();
        builder.startObject("snapshots");
        for (SnapshotFiles snapshot : this.shardSnapshots) {
            builder.startObject(snapshot.snapshot());
            builder.startArray("files");
            for (BlobStoreIndexShardSnapshot.FileInfo fileInfo : snapshot.indexFiles()) {
                builder.value(fileInfo.name());
            }
            builder.endArray();
            if (snapshot.shardStateIdentifier() != null) {
                builder.field("shard_state_id", snapshot.shardStateIdentifier());
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public static BlobStoreIndexShardSnapshots fromXContent(XContentParser parser) throws IOException {
        String currentFieldName;
        XContentParser.Token token = parser.currentToken();
        if (token == null) {
            token = parser.nextToken();
        }
        ArrayList<Tuple<String, List<String>>> snapshotsAndFiles = new ArrayList<Tuple<String, List<String>>>();
        HashMap<String, String> historyUUIDs = new HashMap<String, String>();
        HashMap<String, BlobStoreIndexShardSnapshot.FileInfo> files = new HashMap<String, BlobStoreIndexShardSnapshot.FileInfo>();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, token, parser);
        block4: while ((currentFieldName = parser.nextFieldName()) != null) {
            token = parser.nextToken();
            switch (token) {
                case START_ARRAY: {
                    if (!"files".equals(currentFieldName)) {
                        XContentParserUtils.throwUnknownField(currentFieldName, parser);
                    }
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        BlobStoreIndexShardSnapshot.FileInfo fileInfo = BlobStoreIndexShardSnapshot.FileInfo.fromXContent(parser);
                        files.put(fileInfo.name(), fileInfo);
                    }
                    continue block4;
                }
                case START_OBJECT: {
                    String snapshot;
                    if (!"snapshots".equals(currentFieldName)) {
                        XContentParserUtils.throwUnknownField(currentFieldName, parser);
                    }
                    while ((snapshot = parser.nextFieldName()) != null) {
                        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.nextToken(), parser);
                        while ((currentFieldName = parser.nextFieldName()) != null) {
                            token = parser.nextToken();
                            if ("files".equals(currentFieldName)) {
                                if (token != XContentParser.Token.START_ARRAY) continue;
                                snapshotsAndFiles.add(Tuple.tuple(snapshot, XContentParserUtils.parseList(parser, XContentParser::text)));
                                continue;
                            }
                            if (!"shard_state_id".equals(currentFieldName)) continue;
                            historyUUIDs.put(snapshot, parser.text());
                        }
                    }
                    continue block4;
                }
            }
            XContentParserUtils.throwUnknownToken(token, parser);
        }
        ArrayList<SnapshotFiles> snapshots = new ArrayList<SnapshotFiles>(snapshotsAndFiles.size());
        for (Tuple tuple : snapshotsAndFiles) {
            ArrayList<BlobStoreIndexShardSnapshot.FileInfo> fileInfosBuilder = new ArrayList<BlobStoreIndexShardSnapshot.FileInfo>();
            for (String file : (List)tuple.v2()) {
                BlobStoreIndexShardSnapshot.FileInfo fileInfo = (BlobStoreIndexShardSnapshot.FileInfo)files.get(file);
                assert (fileInfo != null);
                fileInfosBuilder.add(fileInfo);
            }
            snapshots.add(new SnapshotFiles((String)tuple.v1(), Collections.unmodifiableList(fileInfosBuilder), (String)historyUUIDs.get(tuple.v1())));
        }
        return new BlobStoreIndexShardSnapshots(files, snapshots);
    }

    static final class Fields {
        static final String FILES = "files";
        static final String SNAPSHOTS = "snapshots";
        static final String SHARD_STATE_ID = "shard_state_id";

        Fields() {
        }
    }
}

