/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import java.util.Objects;
import java.util.function.Function;
import org.apache.lucene.index.IndexReader;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.engine.Engine;

public abstract class MultiEngineGet {
    private IndexReader.CacheKey lastKey;
    private Engine.Searcher lastWrapped;
    private final Thread creationThread = Thread.currentThread();
    private final Function<Engine.Searcher, Engine.Searcher> wrapper;

    MultiEngineGet(Function<Engine.Searcher, Engine.Searcher> wrapper) {
        this.wrapper = wrapper;
    }

    final boolean assertAccessingThread() {
        assert (this.creationThread == Thread.currentThread()) : "created by [" + this.creationThread + "] != current thread [" + Thread.currentThread() + "]";
        return true;
    }

    public abstract Engine.GetResult get(Engine.Get var1);

    final Engine.Searcher wrapSearchSearchWithCache(Engine.Searcher searcher) {
        IndexReader.CacheKey cacheKey;
        assert (this.assertAccessingThread());
        IndexReader.CacheHelper cacheHelper = searcher.getIndexReader().getReaderCacheHelper();
        IndexReader.CacheKey cacheKey2 = cacheKey = cacheHelper != null ? cacheHelper.getKey() : null;
        if (cacheKey == null) {
            return this.wrapper.apply(searcher);
        }
        if (!Objects.equals(this.lastKey, cacheKey)) {
            Releasables.close(this.lastWrapped, () -> {
                this.lastWrapped = null;
            });
            this.lastWrapped = this.wrapper.apply(searcher);
            this.lastKey = cacheKey;
        }
        return new Engine.Searcher(this.lastWrapped.source(), this.lastWrapped.getIndexReader(), this.lastWrapped.getSimilarity(), this.lastWrapped.getQueryCache(), this.lastWrapped.getQueryCachingPolicy(), () -> {});
    }

    final void releaseCachedSearcher() {
        assert (this.assertAccessingThread());
        Releasables.close((Releasable)this.lastWrapped);
    }
}

