/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public class IndexingStats
implements Writeable,
ToXContentFragment {
    private final Stats totalStats;

    public IndexingStats() {
        this.totalStats = new Stats();
    }

    public IndexingStats(StreamInput in) throws IOException {
        this.totalStats = new Stats(in);
        if (in.getTransportVersion().before(TransportVersions.V_8_0_0) && in.readBoolean()) {
            Map<String, Stats> typeStats = in.readMap(Stats::new);
            assert (typeStats.size() == 1);
            assert (typeStats.containsKey("_doc"));
        }
    }

    public IndexingStats(Stats totalStats) {
        this.totalStats = totalStats;
    }

    public void add(IndexingStats indexingStats) {
        if (indexingStats == null) {
            return;
        }
        this.addTotals(indexingStats);
    }

    public void addTotals(IndexingStats indexingStats) {
        if (indexingStats == null) {
            return;
        }
        this.totalStats.add(indexingStats.totalStats);
    }

    public Stats getTotal() {
        return this.totalStats;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("indexing");
        this.totalStats.toXContent(builder, params);
        if (builder.getRestApiVersion() == RestApiVersion.V_7 && params.param("types") != null) {
            builder.startObject("types");
            builder.startObject("_doc");
            this.totalStats.toXContent(builder, params);
            builder.endObject();
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexingStats that = (IndexingStats)o;
        return Objects.equals(this.totalStats, that.totalStats);
    }

    public int hashCode() {
        return Objects.hash(this.totalStats);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.totalStats.writeTo(out);
        if (out.getTransportVersion().before(TransportVersions.V_8_0_0)) {
            out.writeBoolean(false);
        }
    }

    public static class Stats
    implements Writeable,
    ToXContentFragment {
        private static final TransportVersion WRITE_LOAD_AVG_SUPPORTED_VERSION = TransportVersions.V_8_6_0;
        private long indexCount;
        private long indexTimeInMillis;
        private long indexCurrent;
        private long indexFailedCount;
        private long deleteCount;
        private long deleteTimeInMillis;
        private long deleteCurrent;
        private long noopUpdateCount;
        private long throttleTimeInMillis;
        private boolean isThrottled;
        private long totalIndexingTimeSinceShardStartedInNanos;
        private long totalActiveTimeInNanos;

        Stats() {
        }

        public Stats(StreamInput in) throws IOException {
            this.indexCount = in.readVLong();
            this.indexTimeInMillis = in.readVLong();
            this.indexCurrent = in.readVLong();
            this.indexFailedCount = in.readVLong();
            this.deleteCount = in.readVLong();
            this.deleteTimeInMillis = in.readVLong();
            this.deleteCurrent = in.readVLong();
            this.noopUpdateCount = in.readVLong();
            this.isThrottled = in.readBoolean();
            this.throttleTimeInMillis = in.readLong();
            if (in.getTransportVersion().onOrAfter(WRITE_LOAD_AVG_SUPPORTED_VERSION)) {
                this.totalIndexingTimeSinceShardStartedInNanos = in.readLong();
                this.totalActiveTimeInNanos = in.readLong();
            }
        }

        public Stats(long indexCount, long indexTimeInMillis, long indexCurrent, long indexFailedCount, long deleteCount, long deleteTimeInMillis, long deleteCurrent, long noopUpdateCount, boolean isThrottled, long throttleTimeInMillis, long totalIndexingTimeSinceShardStartedInNanos, long totalActiveTimeInNanos) {
            this.indexCount = indexCount;
            this.indexTimeInMillis = indexTimeInMillis;
            this.indexCurrent = indexCurrent;
            this.indexFailedCount = indexFailedCount;
            this.deleteCount = deleteCount;
            this.deleteTimeInMillis = deleteTimeInMillis;
            this.deleteCurrent = deleteCurrent;
            this.noopUpdateCount = noopUpdateCount;
            this.isThrottled = isThrottled;
            this.throttleTimeInMillis = throttleTimeInMillis;
            this.totalIndexingTimeSinceShardStartedInNanos = totalIndexingTimeSinceShardStartedInNanos;
            this.totalActiveTimeInNanos = totalActiveTimeInNanos;
        }

        public void add(Stats stats) {
            this.indexCount += stats.indexCount;
            this.indexTimeInMillis += stats.indexTimeInMillis;
            this.indexCurrent += stats.indexCurrent;
            this.indexFailedCount += stats.indexFailedCount;
            this.deleteCount += stats.deleteCount;
            this.deleteTimeInMillis += stats.deleteTimeInMillis;
            this.deleteCurrent += stats.deleteCurrent;
            this.noopUpdateCount += stats.noopUpdateCount;
            this.throttleTimeInMillis += stats.throttleTimeInMillis;
            if (this.isThrottled != stats.isThrottled) {
                this.isThrottled = true;
            }
            this.totalIndexingTimeSinceShardStartedInNanos += stats.totalIndexingTimeSinceShardStartedInNanos;
            this.totalActiveTimeInNanos += stats.totalActiveTimeInNanos;
        }

        public long getIndexCount() {
            return this.indexCount;
        }

        public long getIndexFailedCount() {
            return this.indexFailedCount;
        }

        public TimeValue getIndexTime() {
            return new TimeValue(this.indexTimeInMillis);
        }

        public long getIndexCurrent() {
            return this.indexCurrent;
        }

        public long getDeleteCount() {
            return this.deleteCount;
        }

        public boolean isThrottled() {
            return this.isThrottled;
        }

        public TimeValue getThrottleTime() {
            return new TimeValue(this.throttleTimeInMillis);
        }

        public TimeValue getDeleteTime() {
            return new TimeValue(this.deleteTimeInMillis);
        }

        public long getDeleteCurrent() {
            return this.deleteCurrent;
        }

        public long getNoopUpdateCount() {
            return this.noopUpdateCount;
        }

        public double getWriteLoad() {
            return this.totalActiveTimeInNanos > 0L ? (double)this.totalIndexingTimeSinceShardStartedInNanos / (double)this.totalActiveTimeInNanos : 0.0;
        }

        public long getTotalActiveTimeInMillis() {
            return TimeUnit.NANOSECONDS.toMillis(this.totalActiveTimeInNanos);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.indexCount);
            out.writeVLong(this.indexTimeInMillis);
            out.writeVLong(this.indexCurrent);
            out.writeVLong(this.indexFailedCount);
            out.writeVLong(this.deleteCount);
            out.writeVLong(this.deleteTimeInMillis);
            out.writeVLong(this.deleteCurrent);
            out.writeVLong(this.noopUpdateCount);
            out.writeBoolean(this.isThrottled);
            out.writeLong(this.throttleTimeInMillis);
            if (out.getTransportVersion().onOrAfter(WRITE_LOAD_AVG_SUPPORTED_VERSION)) {
                out.writeLong(this.totalIndexingTimeSinceShardStartedInNanos);
                out.writeLong(this.totalActiveTimeInNanos);
            }
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("index_total", this.indexCount);
            builder.humanReadableField("index_time_in_millis", "index_time", this.getIndexTime());
            builder.field("index_current", this.indexCurrent);
            builder.field("index_failed", this.indexFailedCount);
            builder.field("delete_total", this.deleteCount);
            builder.humanReadableField("delete_time_in_millis", "delete_time", this.getDeleteTime());
            builder.field("delete_current", this.deleteCurrent);
            builder.field("noop_update_total", this.noopUpdateCount);
            builder.field("is_throttled", this.isThrottled);
            builder.humanReadableField("throttle_time_in_millis", "throttle_time", this.getThrottleTime());
            builder.field("write_load", this.getWriteLoad());
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Stats that = (Stats)o;
            return this.indexCount == that.indexCount && this.indexTimeInMillis == that.indexTimeInMillis && this.indexCurrent == that.indexCurrent && this.indexFailedCount == that.indexFailedCount && this.deleteCount == that.deleteCount && this.deleteTimeInMillis == that.deleteTimeInMillis && this.deleteCurrent == that.deleteCurrent && this.noopUpdateCount == that.noopUpdateCount && this.isThrottled == that.isThrottled && this.throttleTimeInMillis == that.throttleTimeInMillis && this.totalIndexingTimeSinceShardStartedInNanos == that.totalIndexingTimeSinceShardStartedInNanos && this.totalActiveTimeInNanos == that.totalActiveTimeInNanos;
        }

        public int hashCode() {
            return Objects.hash(this.indexCount, this.indexTimeInMillis, this.indexCurrent, this.indexFailedCount, this.deleteCount, this.deleteTimeInMillis, this.deleteCurrent, this.noopUpdateCount, this.isThrottled, this.throttleTimeInMillis, this.totalIndexingTimeSinceShardStartedInNanos, this.totalActiveTimeInNanos);
        }
    }

    static final class Fields {
        static final String INDEXING = "indexing";
        static final String TYPES = "types";
        static final String INDEX_TOTAL = "index_total";
        static final String INDEX_TIME = "index_time";
        static final String INDEX_TIME_IN_MILLIS = "index_time_in_millis";
        static final String INDEX_CURRENT = "index_current";
        static final String INDEX_FAILED = "index_failed";
        static final String DELETE_TOTAL = "delete_total";
        static final String DELETE_TIME = "delete_time";
        static final String DELETE_TIME_IN_MILLIS = "delete_time_in_millis";
        static final String DELETE_CURRENT = "delete_current";
        static final String NOOP_UPDATE_TOTAL = "noop_update_total";
        static final String IS_THROTTLED = "is_throttled";
        static final String THROTTLED_TIME_IN_MILLIS = "throttle_time_in_millis";
        static final String THROTTLED_TIME = "throttle_time";
        static final String WRITE_LOAD = "write_load";

        Fields() {
        }
    }
}

