/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.net.InetAddress;
import java.time.ZoneId;
import java.util.Base64;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.StringHelper;
import org.elasticsearch.cluster.routing.IndexRouting;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.hash.Murmur3Hasher;
import org.elasticsearch.common.hash.MurmurHash3;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.common.util.ByteUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.plain.SortedOrdinalsIndexFieldData;
import org.elasticsearch.index.mapper.DocValueFetcher;
import org.elasticsearch.index.mapper.DocumentDimensions;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperException;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.TsidExtractingIdFieldMapper;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.script.field.DelegateDocValuesField;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;

public class TimeSeriesIdFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_tsid";
    public static final String CONTENT_TYPE = "_tsid";
    public static final TimeSeriesIdFieldType FIELD_TYPE = new TimeSeriesIdFieldType();
    public static final TimeSeriesIdFieldMapper INSTANCE = new TimeSeriesIdFieldMapper();
    private static final Base64.Encoder BASE64_ENCODER = Base64.getUrlEncoder().withoutPadding();
    public static final MetadataFieldMapper.TypeParser PARSER = new MetadataFieldMapper.FixedTypeParser(c -> c.getIndexSettings().getMode().timeSeriesIdFieldMapper());

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder().init(this);
    }

    private TimeSeriesIdFieldMapper() {
        super(FIELD_TYPE);
    }

    @Override
    public void postParse(DocumentParserContext context) throws IOException {
        assert (!this.fieldType().isIndexed());
        TimeSeriesIdBuilder timeSeriesIdBuilder = (TimeSeriesIdBuilder)context.getDimensions();
        BytesRef timeSeriesId = this.getIndexVersionCreated(context).before(IndexVersions.TIME_SERIES_ID_HASHING) ? timeSeriesIdBuilder.buildLegacyTsid().toBytesRef() : timeSeriesIdBuilder.buildTsidHash().toBytesRef();
        context.doc().add(new SortedDocValuesField(this.fieldType().name(), timeSeriesId));
        TsidExtractingIdFieldMapper.createField(context, this.getIndexVersionCreated(context).before(IndexVersions.TIME_SERIES_ROUTING_HASH_IN_ID) ? timeSeriesIdBuilder.routingBuilder : null, timeSeriesId);
    }

    private IndexVersion getIndexVersionCreated(DocumentParserContext context) {
        return context.indexSettings().getIndexVersionCreated();
    }

    @Override
    protected String contentType() {
        return "_tsid";
    }

    @Override
    public SourceLoader.SyntheticFieldLoader syntheticFieldLoader() {
        return SourceLoader.SyntheticFieldLoader.NOTHING;
    }

    public static Object encodeTsid(StreamInput in) {
        try {
            return TimeSeriesIdFieldMapper.base64Encode(in.readSlicedBytesReference().toBytesRef());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to read tsid");
        }
    }

    public static Object encodeTsid(BytesRef bytesRef) {
        return TimeSeriesIdFieldMapper.base64Encode(bytesRef);
    }

    private static String base64Encode(BytesRef bytesRef) {
        byte[] bytes = new byte[bytesRef.length];
        System.arraycopy(bytesRef.bytes, bytesRef.offset, bytes, 0, bytesRef.length);
        return BASE64_ENCODER.encodeToString(bytes);
    }

    public static Map<String, Object> decodeTsidAsMap(BytesRef bytesRef) {
        Map<String, Object> map;
        block8: {
            StreamInput input = new BytesArray(bytesRef).streamInput();
            try {
                map = TimeSeriesIdFieldMapper.decodeTsidAsMap(input);
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new IllegalArgumentException("Dimension field cannot be deserialized.", ex);
                }
            }
            input.close();
        }
        return map;
    }

    public static Map<String, Object> decodeTsidAsMap(StreamInput in) {
        try {
            int size = in.readVInt();
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(size);
            block12: for (int i = 0; i < size; ++i) {
                String name = null;
                try {
                    name = in.readSlicedBytesReference().utf8ToString();
                }
                catch (AssertionError ae) {
                    throw new IllegalArgumentException("Error parsing keyword dimension: " + ((Throwable)((Object)ae)).getMessage(), (Throwable)((Object)ae));
                }
                int type = in.read();
                switch (type) {
                    case 115: {
                        try {
                            result.put(name, in.readSlicedBytesReference().utf8ToString());
                            continue block12;
                        }
                        catch (AssertionError ae) {
                            throw new IllegalArgumentException("Error parsing keyword dimension: " + ((Throwable)((Object)ae)).getMessage(), (Throwable)((Object)ae));
                        }
                    }
                    case 108: {
                        result.put(name, in.readLong());
                        continue block12;
                    }
                    case 117: {
                        Object ul = DocValueFormat.UNSIGNED_LONG_SHIFTED.format(in.readLong());
                        result.put(name, ul);
                        continue block12;
                    }
                    case 100: {
                        result.put(name, in.readDouble());
                        continue block12;
                    }
                    default: {
                        throw new IllegalArgumentException("Cannot parse [" + name + "]: Unknown type [" + type + "]");
                    }
                }
            }
            return result;
        }
        catch (IOException | IllegalArgumentException e) {
            throw new IllegalArgumentException("Error formatting _tsid: " + e.getMessage(), e);
        }
    }

    public static class Builder
    extends MetadataFieldMapper.Builder {
        protected Builder() {
            super("_tsid");
        }

        @Override
        protected FieldMapper.Parameter<?>[] getParameters() {
            return FieldMapper.EMPTY_PARAMETERS;
        }

        @Override
        public TimeSeriesIdFieldMapper build() {
            return INSTANCE;
        }
    }

    public static final class TimeSeriesIdFieldType
    extends MappedFieldType {
        private TimeSeriesIdFieldType() {
            super("_tsid", false, false, true, TextSearchInfo.NONE, Collections.emptyMap());
        }

        @Override
        public String typeName() {
            return "_tsid";
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            return new DocValueFetcher(this.docValueFormat(format, null), (IndexFieldData<?>)context.getForField(this, MappedFieldType.FielddataOperation.SEARCH));
        }

        @Override
        public DocValueFormat docValueFormat(String format, ZoneId timeZone) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            return DocValueFormat.TIME_SERIES_ID;
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
            this.failIfNoDocValues();
            return new SortedOrdinalsIndexFieldData.Builder(this.name(), CoreValuesSourceType.KEYWORD, (dv, n) -> new DelegateDocValuesField(new ScriptDocValues.Strings(new ScriptDocValues.StringsSupplier(FieldData.toString(dv))), n));
        }

        @Override
        public Query termQuery(Object value, SearchExecutionContext context) {
            throw new IllegalArgumentException("[_tsid] is not searchable");
        }
    }

    public static class TimeSeriesIdBuilder
    implements DocumentDimensions {
        private static final int SEED = 0;
        public static final int MAX_DIMENSIONS = 512;
        private final Murmur3Hasher tsidHasher = new Murmur3Hasher(0L);
        private final SortedSet<Dimension> dimensions = new TreeSet<Dimension>(Comparator.comparing(o -> o.name));
        @Nullable
        private final IndexRouting.ExtractFromSource.Builder routingBuilder;
        private static final int MAX_HASH_LEN_BYTES = 2;
        static final /* synthetic */ boolean $assertionsDisabled;

        public TimeSeriesIdBuilder(@Nullable IndexRouting.ExtractFromSource.Builder routingBuilder) {
            this.routingBuilder = routingBuilder;
        }

        public BytesReference buildLegacyTsid() throws IOException {
            if (this.dimensions.isEmpty()) {
                throw new IllegalArgumentException("Dimension fields are missing.");
            }
            try (BytesStreamOutput out = new BytesStreamOutput();){
                out.writeVInt(this.dimensions.size());
                for (Dimension entry : this.dimensions) {
                    out.writeBytesRef(entry.name);
                    entry.value.writeTo(out);
                }
                BytesReference bytesReference = out.bytes();
                return bytesReference;
            }
        }

        public BytesReference buildTsidHash() {
            int numberOfDimensions = Math.min(512, this.dimensions.size());
            int len = TimeSeriesIdBuilder.tsidHashLen(numberOfDimensions);
            byte[] tsidHash = new byte[2 + len];
            int tsidHashIndex = StreamOutput.putVInt(tsidHash, len, 0);
            this.tsidHasher.reset();
            for (Dimension dimension : this.dimensions) {
                this.tsidHasher.update(dimension.name.bytes);
            }
            int tsidHashStartIndex = tsidHashIndex = this.writeHash128(this.tsidHasher.digestHash(), tsidHash, tsidHashIndex);
            for (Dimension dimension : this.dimensions) {
                if (tsidHashIndex - tsidHashStartIndex >= 4 * numberOfDimensions) break;
                BytesRef dimensionValueBytesRef = dimension.value.toBytesRef();
                ByteUtils.writeIntLE(StringHelper.murmurhash3_x86_32(dimensionValueBytesRef.bytes, dimensionValueBytesRef.offset, dimensionValueBytesRef.length, 0), tsidHash, tsidHashIndex);
                tsidHashIndex += 4;
            }
            this.tsidHasher.reset();
            for (Dimension dimension : this.dimensions) {
                this.tsidHasher.update(dimension.value.toBytesRef().bytes);
            }
            tsidHashIndex = this.writeHash128(this.tsidHasher.digestHash(), tsidHash, tsidHashIndex);
            return new BytesArray(tsidHash, 0, tsidHashIndex);
        }

        private static int tsidHashLen(int numberOfDimensions) {
            return 32 + 4 * numberOfDimensions;
        }

        private int writeHash128(MurmurHash3.Hash128 hash128, byte[] buffer, int tsidHashIndex) {
            ByteUtils.writeLongLE(hash128.h1, buffer, tsidHashIndex);
            ByteUtils.writeLongLE(hash128.h2, buffer, tsidHashIndex += 8);
            return tsidHashIndex += 8;
        }

        @Override
        public DocumentDimensions addString(String fieldName, BytesRef utf8Value) {
            try (BytesStreamOutput out = new BytesStreamOutput();){
                out.write(115);
                out.writeBytesRef(utf8Value);
                this.add(fieldName, out.bytes());
                if (this.routingBuilder != null) {
                    this.routingBuilder.addMatching(fieldName, utf8Value);
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Dimension field cannot be serialized.", e);
            }
            return this;
        }

        @Override
        public DocumentDimensions addIp(String fieldName, InetAddress value) {
            return this.addString(fieldName, NetworkAddress.format(value));
        }

        @Override
        public DocumentDimensions addLong(String fieldName, long value) {
            try (BytesStreamOutput out = new BytesStreamOutput();){
                out.write(108);
                out.writeLong(value);
                this.add(fieldName, out.bytes());
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Dimension field cannot be serialized.", e);
            }
            return this;
        }

        @Override
        public DocumentDimensions addUnsignedLong(String fieldName, long value) {
            BytesStreamOutput out = new BytesStreamOutput();
            try {
                Object ul = DocValueFormat.UNSIGNED_LONG_SHIFTED.format(value);
                if (ul instanceof Long) {
                    Long l = (Long)ul;
                    out.write(108);
                    out.writeLong(l);
                } else {
                    out.write(117);
                    out.writeLong(value);
                }
                this.add(fieldName, out.bytes());
                TimeSeriesIdBuilder timeSeriesIdBuilder = this;
                out.close();
                return timeSeriesIdBuilder;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Dimension field cannot be serialized.", e);
                }
            }
        }

        @Override
        public DocumentDimensions validate(IndexSettings settings) {
            if (settings.getIndexVersionCreated().before(IndexVersions.TIME_SERIES_ID_HASHING) && (long)this.dimensions.size() > settings.getValue(MapperService.INDEX_MAPPING_DIMENSION_FIELDS_LIMIT_SETTING)) {
                throw new MapperException("Too many dimension fields [" + this.dimensions.size() + "], max [" + settings.getValue(MapperService.INDEX_MAPPING_DIMENSION_FIELDS_LIMIT_SETTING) + "] dimension fields allowed");
            }
            return this;
        }

        private void add(String fieldName, BytesReference encoded) throws IOException {
            if (!this.dimensions.add(new Dimension(new BytesRef(fieldName), encoded))) {
                throw new IllegalArgumentException("Dimension field [" + fieldName + "] cannot be a multi-valued field.");
            }
        }

        static {
            boolean bl = $assertionsDisabled = !TimeSeriesIdFieldMapper.class.desiredAssertionStatus();
            if (!$assertionsDisabled && 2 != StreamOutput.putVInt(new byte[2], TimeSeriesIdBuilder.tsidHashLen(512), 0)) {
                throw new AssertionError();
            }
        }

        private record Dimension(BytesRef name, BytesReference value) {
        }
    }
}

