/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.elasticsearch.index.mapper.IgnoreMalformedStoredValues;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.xcontent.XContentBuilder;

public abstract class SortedNumericDocValuesSyntheticFieldLoader
implements SourceLoader.SyntheticFieldLoader {
    private final String name;
    private final String simpleName;
    private final IgnoreMalformedStoredValues ignoreMalformedValues;
    private Values values = NO_VALUES;
    private static final Values NO_VALUES = new Values(){

        @Override
        public int count() {
            return 0;
        }

        @Override
        public void write(XContentBuilder b) {
        }
    };

    protected SortedNumericDocValuesSyntheticFieldLoader(String name, String simpleName, boolean loadIgnoreMalformedValues) {
        this.name = name;
        this.simpleName = simpleName;
        this.ignoreMalformedValues = loadIgnoreMalformedValues ? IgnoreMalformedStoredValues.stored(name) : IgnoreMalformedStoredValues.empty();
    }

    protected abstract void writeValue(XContentBuilder var1, long var2) throws IOException;

    @Override
    public Stream<Map.Entry<String, SourceLoader.SyntheticFieldLoader.StoredFieldLoader>> storedFieldLoaders() {
        return this.ignoreMalformedValues.storedFieldLoaders();
    }

    @Override
    public SourceLoader.SyntheticFieldLoader.DocValuesLoader docValuesLoader(LeafReader reader, int[] docIdsInLeaf) throws IOException {
        NumericDocValues single;
        SortedNumericDocValues dv = SortedNumericDocValuesSyntheticFieldLoader.docValuesOrNull(reader, this.name);
        if (dv == null) {
            this.values = NO_VALUES;
            return null;
        }
        if (docIdsInLeaf != null && docIdsInLeaf.length > 1 && (single = DocValues.unwrapSingleton(dv)) != null) {
            SingletonDocValuesLoader loader = this.buildSingletonDocValuesLoader(single, docIdsInLeaf);
            this.values = loader == null ? NO_VALUES : loader;
            return loader;
        }
        ImmediateDocValuesLoader loader = new ImmediateDocValuesLoader(dv);
        this.values = loader;
        return loader;
    }

    @Override
    public boolean hasValue() {
        return this.values.count() > 0 || this.ignoreMalformedValues.count() > 0;
    }

    @Override
    public void write(XContentBuilder b) throws IOException {
        switch (this.values.count() + this.ignoreMalformedValues.count()) {
            case 0: {
                return;
            }
            case 1: {
                b.field(this.simpleName);
                if (this.values.count() > 0) {
                    assert (this.values.count() == 1);
                    assert (this.ignoreMalformedValues.count() == 0);
                    this.values.write(b);
                } else {
                    assert (this.ignoreMalformedValues.count() == 1);
                    this.ignoreMalformedValues.write(b);
                }
                return;
            }
        }
        b.startArray(this.simpleName);
        this.values.write(b);
        this.ignoreMalformedValues.write(b);
        b.endArray();
    }

    private SingletonDocValuesLoader buildSingletonDocValuesLoader(NumericDocValues singleton, int[] docIdsInLeaf) throws IOException {
        long[] values = new long[docIdsInLeaf.length];
        boolean[] hasValue = new boolean[docIdsInLeaf.length];
        boolean found = false;
        for (int d = 0; d < docIdsInLeaf.length; ++d) {
            if (!singleton.advanceExact(docIdsInLeaf[d])) {
                hasValue[d] = false;
                continue;
            }
            hasValue[d] = true;
            values[d] = singleton.longValue();
            found = true;
        }
        if (!found) {
            return null;
        }
        return new SingletonDocValuesLoader(docIdsInLeaf, values, hasValue);
    }

    public static SortedNumericDocValues docValuesOrNull(LeafReader reader, String fieldName) throws IOException {
        SortedNumericDocValues dv = reader.getSortedNumericDocValues(fieldName);
        if (dv != null) {
            return dv;
        }
        NumericDocValues single = reader.getNumericDocValues(fieldName);
        if (single != null) {
            return DocValues.singleton(single);
        }
        return null;
    }

    private static interface Values {
        public int count();

        public void write(XContentBuilder var1) throws IOException;
    }

    private class SingletonDocValuesLoader
    implements SourceLoader.SyntheticFieldLoader.DocValuesLoader,
    Values {
        private final int[] docIdsInLeaf;
        private final long[] values;
        private final boolean[] hasValue;
        private int idx = -1;

        private SingletonDocValuesLoader(int[] docIdsInLeaf, long[] values, boolean[] hasValue) {
            this.docIdsInLeaf = docIdsInLeaf;
            this.values = values;
            this.hasValue = hasValue;
        }

        @Override
        public boolean advanceToDoc(int docId) throws IOException {
            ++this.idx;
            if (this.docIdsInLeaf[this.idx] != docId) {
                throw new IllegalArgumentException("expected to be called with [" + this.docIdsInLeaf[this.idx] + "] but was called with " + docId + " instead");
            }
            return this.hasValue[this.idx];
        }

        @Override
        public int count() {
            return this.hasValue[this.idx] ? 1 : 0;
        }

        @Override
        public void write(XContentBuilder b) throws IOException {
            if (!this.hasValue[this.idx]) {
                return;
            }
            SortedNumericDocValuesSyntheticFieldLoader.this.writeValue(b, this.values[this.idx]);
        }
    }

    private class ImmediateDocValuesLoader
    implements SourceLoader.SyntheticFieldLoader.DocValuesLoader,
    Values {
        private final SortedNumericDocValues dv;
        private boolean hasValue;

        ImmediateDocValuesLoader(SortedNumericDocValues dv) {
            this.dv = dv;
        }

        @Override
        public boolean advanceToDoc(int docId) throws IOException {
            this.hasValue = this.dv.advanceExact(docId);
            return this.hasValue;
        }

        @Override
        public int count() {
            return this.hasValue ? this.dv.docValueCount() : 0;
        }

        @Override
        public void write(XContentBuilder b) throws IOException {
            if (!this.hasValue) {
                return;
            }
            for (int i = 0; i < this.dv.docValueCount(); ++i) {
                SortedNumericDocValuesSyntheticFieldLoader.this.writeValue(b, this.dv.nextValue());
            }
        }
    }
}

