/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.SortField;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.LeafFieldData;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fieldvisitor.LeafStoredFieldLoader;
import org.elasticsearch.index.fieldvisitor.StoredFieldLoader;
import org.elasticsearch.script.field.DocValuesScriptFieldFactory;
import org.elasticsearch.script.field.ToScriptFieldFactory;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.MultiValueMode;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.sort.BucketedSort;
import org.elasticsearch.search.sort.SortOrder;

public abstract class StoredFieldIndexFieldData<T>
implements IndexFieldData<StoredFieldLeafFieldData> {
    private final String fieldName;
    private final ValuesSourceType valuesSourceType;
    protected final ToScriptFieldFactory<T> toScriptFieldFactory;
    protected final StoredFieldLoader loader;

    protected StoredFieldIndexFieldData(String fieldName, ValuesSourceType valuesSourceType, ToScriptFieldFactory<T> toScriptFieldFactory) {
        this.fieldName = fieldName;
        this.valuesSourceType = valuesSourceType;
        this.toScriptFieldFactory = toScriptFieldFactory;
        this.loader = StoredFieldLoader.create(false, Set.of(fieldName));
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public ValuesSourceType getValuesSourceType() {
        return this.valuesSourceType;
    }

    @Override
    public final StoredFieldLeafFieldData load(LeafReaderContext context) {
        try {
            return this.loadDirect(context);
        }
        catch (Exception e) {
            throw ExceptionsHelper.convertToElastic(e);
        }
    }

    @Override
    public final StoredFieldLeafFieldData loadDirect(LeafReaderContext context) throws IOException {
        return new StoredFieldLeafFieldData(this.loader.getLoader(context, null));
    }

    protected abstract T loadLeaf(LeafStoredFieldLoader var1);

    @Override
    public SortField sortField(Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, boolean reverse) {
        throw new IllegalArgumentException("not supported for stored field fallback");
    }

    @Override
    public BucketedSort newBucketedSort(BigArrays bigArrays, Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
        throw new IllegalArgumentException("not supported for stored field fallback");
    }

    public class StoredFieldLeafFieldData
    implements LeafFieldData {
        private final LeafStoredFieldLoader loader;

        protected StoredFieldLeafFieldData(LeafStoredFieldLoader loader) {
            this.loader = loader;
        }

        @Override
        public DocValuesScriptFieldFactory getScriptFieldFactory(String name) {
            return StoredFieldIndexFieldData.this.toScriptFieldFactory.getScriptFieldFactory(StoredFieldIndexFieldData.this.loadLeaf(this.loader), StoredFieldIndexFieldData.this.fieldName);
        }

        @Override
        public long ramBytesUsed() {
            return 0L;
        }

        @Override
        public void close() {
        }

        @Override
        public SortedBinaryDocValues getBytesValues() {
            throw new IllegalArgumentException("not supported for source fallback");
        }
    }
}

