/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.SourceValueFetcherIndexFieldData;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.script.field.DocValuesScriptFieldFactory;
import org.elasticsearch.script.field.ToScriptFieldFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.lookup.Source;
import org.elasticsearch.search.lookup.SourceProvider;

public class SourceValueFetcherSortedNumericIndexFieldData
extends SourceValueFetcherIndexFieldData<SortedNumericDocValues> {
    protected SourceValueFetcherSortedNumericIndexFieldData(String fieldName, ValuesSourceType valuesSourceType, ValueFetcher valueFetcher, SourceProvider sourceProvider, ToScriptFieldFactory<SortedNumericDocValues> toScriptFieldFactory) {
        super(fieldName, valuesSourceType, valueFetcher, sourceProvider, toScriptFieldFactory);
    }

    @Override
    public SourceValueFetcherSortedNumericLeafFieldData loadDirect(LeafReaderContext context) throws Exception {
        return new SourceValueFetcherSortedNumericLeafFieldData(this.toScriptFieldFactory, context, this.valueFetcher, this.sourceProvider);
    }

    public static class SourceValueFetcherSortedNumericLeafFieldData
    extends SourceValueFetcherIndexFieldData.SourceValueFetcherLeafFieldData<SortedNumericDocValues> {
        public SourceValueFetcherSortedNumericLeafFieldData(ToScriptFieldFactory<SortedNumericDocValues> toScriptFieldFactory, LeafReaderContext leafReaderContext, ValueFetcher valueFetcher, SourceProvider sourceProvider) {
            super(toScriptFieldFactory, leafReaderContext, valueFetcher, sourceProvider);
        }

        @Override
        public DocValuesScriptFieldFactory getScriptFieldFactory(String name) {
            return this.toScriptFieldFactory.getScriptFieldFactory(new SourceValueFetcherSortedNumericDocValues(this.leafReaderContext, this.valueFetcher, this.sourceProvider), name);
        }
    }

    public static class SourceValueFetcherSortedNumericDocValues
    extends SortedNumericDocValues
    implements SourceValueFetcherIndexFieldData.ValueFetcherDocValues {
        protected final LeafReaderContext leafReaderContext;
        protected final ValueFetcher valueFetcher;
        protected final SourceProvider sourceProvider;
        protected final List<Long> values;
        protected Iterator<Long> iterator;

        public SourceValueFetcherSortedNumericDocValues(LeafReaderContext leafReaderContext, ValueFetcher valueFetcher, SourceProvider sourceProvider) {
            this.leafReaderContext = leafReaderContext;
            this.valueFetcher = valueFetcher;
            this.sourceProvider = sourceProvider;
            this.values = new ArrayList<Long>();
        }

        @Override
        public boolean advanceExact(int doc) throws IOException {
            this.values.clear();
            Source source = this.sourceProvider.getSource(this.leafReaderContext, doc);
            for (Object value : this.valueFetcher.fetchValues(source, doc, Collections.emptyList())) {
                assert (value instanceof Number);
                this.values.add(((Number)value).longValue());
            }
            this.values.sort(Long::compare);
            this.iterator = this.values.iterator();
            return !this.values.isEmpty();
        }

        @Override
        public int docValueCount() {
            return this.values.size();
        }

        @Override
        public long nextValue() throws IOException {
            assert (this.iterator.hasNext());
            return this.iterator.next();
        }

        @Override
        public int docID() {
            throw new UnsupportedOperationException("not supported for source fallback");
        }

        @Override
        public int nextDoc() throws IOException {
            throw new UnsupportedOperationException("not supported for source fallback");
        }

        @Override
        public int advance(int target) throws IOException {
            throw new UnsupportedOperationException("not supported for source fallback");
        }

        @Override
        public long cost() {
            throw new UnsupportedOperationException("not supported for source fallback");
        }
    }

    public static class Builder
    extends SourceValueFetcherIndexFieldData.Builder<SortedNumericDocValues> {
        public Builder(String fieldName, ValuesSourceType valuesSourceType, ValueFetcher valueFetcher, SourceProvider sourceProvider, ToScriptFieldFactory<SortedNumericDocValues> toScriptFieldFactory) {
            super(fieldName, valuesSourceType, valueFetcher, sourceProvider, toScriptFieldFactory);
        }

        public SourceValueFetcherSortedNumericIndexFieldData build(IndexFieldDataCache cache, CircuitBreakerService breakerService) {
            return new SourceValueFetcherSortedNumericIndexFieldData(this.fieldName, this.valuesSourceType, this.valueFetcher, this.sourceProvider, this.toScriptFieldFactory);
        }
    }
}

