/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.store.AlreadyClosedException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.translog.Translog;

public class FlushListeners
implements Closeable {
    private final Logger logger;
    private final ThreadContext threadContext;
    private volatile Tuple<Long, Translog.Location> lastCommit;
    private volatile boolean closed = false;
    private volatile List<Tuple<Translog.Location, ActionListener<Long>>> locationCommitListeners = null;

    public FlushListeners(Logger logger, ThreadContext threadContext) {
        this.logger = logger;
        this.threadContext = threadContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOrNotify(Translog.Location location, ActionListener<Long> listener) {
        Objects.requireNonNull(listener, "listener cannot be null");
        Objects.requireNonNull(location, "location cannot be null");
        Tuple<Long, Translog.Location> lastCommitBeforeSynchronized = this.lastCommit;
        if (lastCommitBeforeSynchronized != null && lastCommitBeforeSynchronized.v2().compareTo(location) >= 0) {
            listener.onResponse(lastCommitBeforeSynchronized.v1());
            return;
        }
        FlushListeners flushListeners = this;
        synchronized (flushListeners) {
            if (this.closed) {
                throw new IllegalStateException("can't wait for flush on a closed index");
            }
            Tuple<Long, Translog.Location> lastCommitAfterSynchronized = this.lastCommit;
            if (lastCommitAfterSynchronized != null && lastCommitAfterSynchronized.v2().compareTo(location) >= 0) {
                listener.onResponse(lastCommitAfterSynchronized.v1());
                return;
            }
            List<Tuple<Translog.Location, ActionListener<Long>>> listeners = this.locationCommitListeners;
            ContextPreservingActionListener<Long> contextPreservingListener = ContextPreservingActionListener.wrapPreservingContext(listener, this.threadContext);
            if (listeners == null) {
                listeners = new ArrayList<Tuple<Translog.Location, ActionListener<Long>>>();
            }
            listeners.add(new Tuple<Translog.Location, ContextPreservingActionListener<Long>>(location, contextPreservingListener));
            this.locationCommitListeners = listeners;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterFlush(long generation, Translog.Location lastCommitLocation) {
        this.lastCommit = new Tuple<Long, Translog.Location>(generation, lastCommitLocation);
        ArrayList<Tuple<Translog.Location, ActionListener<Long>>> listenersToFire = null;
        ArrayList<Tuple<Translog.Location, ActionListener<Long>>> listenersToReregister = null;
        FlushListeners flushListeners = this;
        synchronized (flushListeners) {
            if (this.locationCommitListeners == null) {
                return;
            }
            for (Tuple<Translog.Location, ActionListener<Long>> tuple : this.locationCommitListeners) {
                Translog.Location location = tuple.v1();
                if (location.compareTo(lastCommitLocation) <= 0) {
                    if (listenersToFire == null) {
                        listenersToFire = new ArrayList<Tuple<Translog.Location, ActionListener<Long>>>();
                    }
                    listenersToFire.add(tuple);
                    continue;
                }
                if (listenersToReregister == null) {
                    listenersToReregister = new ArrayList<Tuple<Translog.Location, ActionListener<Long>>>();
                }
                listenersToReregister.add(tuple);
            }
            this.locationCommitListeners = listenersToReregister;
        }
        this.fireListeners(generation, listenersToFire);
    }

    private void fireListeners(long generation, List<Tuple<Translog.Location, ActionListener<Long>>> listenersToFire) {
        if (listenersToFire != null) {
            for (Tuple<Translog.Location, ActionListener<Long>> listener : listenersToFire) {
                try {
                    listener.v2().onResponse(generation);
                }
                catch (Exception e) {
                    this.logger.warn("error firing location refresh listener", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        FlushListeners flushListeners = this;
        synchronized (flushListeners) {
            if (!this.closed) {
                this.closed = true;
                if (this.locationCommitListeners != null) {
                    for (Tuple<Translog.Location, ActionListener<Long>> listener : this.locationCommitListeners) {
                        try {
                            listener.v2().onFailure(new AlreadyClosedException("shard is closed"));
                        }
                        catch (Exception e) {
                            this.logger.warn("error firing checkpoint refresh listener", (Throwable)e);
                            assert (false);
                        }
                    }
                    this.locationCommitListeners = null;
                }
            }
        }
    }
}

