/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http;

import java.util.List;
import java.util.function.Function;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.transport.PortsRange;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.TimeValue;

public final class HttpTransportSettings {
    public static final Setting<Boolean> SETTING_CORS_ENABLED = Setting.boolSetting("http.cors.enabled", false, Setting.Property.NodeScope);
    public static final Setting<String> SETTING_CORS_ALLOW_ORIGIN = new Setting<String>("http.cors.allow-origin", "", value -> value, Setting.Property.NodeScope);
    public static final Setting<Integer> SETTING_CORS_MAX_AGE = Setting.intSetting("http.cors.max-age", 1728000, Setting.Property.NodeScope);
    public static final Setting<String> SETTING_CORS_ALLOW_METHODS = new Setting<String>("http.cors.allow-methods", "OPTIONS,HEAD,GET,POST,PUT,DELETE", value -> value, Setting.Property.NodeScope);
    public static final Setting<String> SETTING_CORS_ALLOW_HEADERS = new Setting<String>("http.cors.allow-headers", "X-Requested-With,Content-Type,Content-Length,Authorization,Accept,User-Agent,X-Elastic-Client-Meta", value -> value, Setting.Property.NodeScope);
    public static final Setting<String> SETTING_CORS_EXPOSE_HEADERS = new Setting<String>("http.cors.expose-headers", "X-elastic-product", value -> value, Setting.Property.NodeScope);
    public static final Setting<Boolean> SETTING_CORS_ALLOW_CREDENTIALS = Setting.boolSetting("http.cors.allow-credentials", false, Setting.Property.NodeScope);
    public static final Setting<Integer> SETTING_PIPELINING_MAX_EVENTS = Setting.intSetting("http.pipelining.max_events", 10000, Setting.Property.NodeScope);
    public static final Setting<Boolean> SETTING_HTTP_COMPRESSION = Setting.boolSetting("http.compression", true, Setting.Property.NodeScope);
    public static final Setting<Integer> SETTING_HTTP_COMPRESSION_LEVEL = Setting.intSetting("http.compression_level", 3, Setting.Property.NodeScope);
    public static final Setting<List<String>> SETTING_HTTP_HOST = Setting.stringListSetting("http.host", Setting.Property.NodeScope);
    public static final Setting<List<String>> SETTING_HTTP_PUBLISH_HOST = Setting.listSetting("http.publish_host", SETTING_HTTP_HOST, Function.identity(), Setting.Property.NodeScope);
    public static final Setting<List<String>> SETTING_HTTP_BIND_HOST = Setting.listSetting("http.bind_host", SETTING_HTTP_HOST, Function.identity(), Setting.Property.NodeScope);
    public static final Setting<PortsRange> SETTING_HTTP_PORT = new Setting<PortsRange>("http.port", "9200-9300", PortsRange::new, Setting.Property.NodeScope);
    public static final Setting<Integer> SETTING_HTTP_PUBLISH_PORT = Setting.intSetting("http.publish_port", -1, -1, Setting.Property.NodeScope);
    public static final Setting<Boolean> SETTING_HTTP_DETAILED_ERRORS_ENABLED = Setting.boolSetting("http.detailed_errors.enabled", true, Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> SETTING_HTTP_MAX_CONTENT_LENGTH = Setting.byteSizeSetting("http.max_content_length", new ByteSizeValue(100L, ByteSizeUnit.MB), ByteSizeValue.ZERO, ByteSizeValue.ofBytes(Integer.MAX_VALUE), Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> SETTING_HTTP_MAX_CHUNK_SIZE = Setting.byteSizeSetting("http.max_chunk_size", new ByteSizeValue(8L, ByteSizeUnit.KB), Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> SETTING_HTTP_MAX_HEADER_SIZE = Setting.byteSizeSetting("http.max_header_size", new ByteSizeValue(16L, ByteSizeUnit.KB), Setting.Property.NodeScope);
    public static final Setting<Integer> SETTING_HTTP_MAX_WARNING_HEADER_COUNT = Setting.intSetting("http.max_warning_header_count", -1, -1, Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> SETTING_HTTP_MAX_WARNING_HEADER_SIZE = Setting.byteSizeSetting("http.max_warning_header_size", ByteSizeValue.MINUS_ONE, Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> SETTING_HTTP_MAX_INITIAL_LINE_LENGTH = Setting.byteSizeSetting("http.max_initial_line_length", new ByteSizeValue(4L, ByteSizeUnit.KB), Setting.Property.NodeScope);
    public static final Setting<TimeValue> SETTING_HTTP_SERVER_SHUTDOWN_GRACE_PERIOD = Setting.positiveTimeSetting("http.shutdown_grace_period", TimeValue.timeValueMillis(0L), Setting.Property.NodeScope);
    public static final Setting<TimeValue> SETTING_HTTP_SERVER_SHUTDOWN_POLL_PERIOD = Setting.positiveTimeSetting("http.shutdown_poll_period", TimeValue.timeValueMinutes(5L), Setting.Property.NodeScope);
    public static final Setting<Boolean> SETTING_HTTP_RESET_COOKIES = Setting.boolSetting("http.reset_cookies", false, Setting.Property.NodeScope);
    public static final Setting<TimeValue> SETTING_HTTP_READ_TIMEOUT = Setting.timeSetting("http.read_timeout", new TimeValue(0L), new TimeValue(0L), Setting.Property.NodeScope);
    public static final Setting<Boolean> SETTING_HTTP_TCP_NO_DELAY = Setting.boolSetting("http.tcp.no_delay", NetworkService.TCP_NO_DELAY, Setting.Property.NodeScope);
    public static final Setting<Boolean> SETTING_HTTP_TCP_KEEP_ALIVE = Setting.boolSetting("http.tcp.keep_alive", NetworkService.TCP_KEEP_ALIVE, Setting.Property.NodeScope);
    public static final Setting<Integer> SETTING_HTTP_TCP_KEEP_IDLE = Setting.intSetting("http.tcp.keep_idle", NetworkService.TCP_KEEP_IDLE, -1, 300, Setting.Property.NodeScope);
    public static final Setting<Integer> SETTING_HTTP_TCP_KEEP_INTERVAL = Setting.intSetting("http.tcp.keep_interval", NetworkService.TCP_KEEP_INTERVAL, -1, 300, Setting.Property.NodeScope);
    public static final Setting<Integer> SETTING_HTTP_TCP_KEEP_COUNT = Setting.intSetting("http.tcp.keep_count", NetworkService.TCP_KEEP_COUNT, -1, Setting.Property.NodeScope);
    public static final Setting<Boolean> SETTING_HTTP_TCP_REUSE_ADDRESS = Setting.boolSetting("http.tcp.reuse_address", NetworkService.TCP_REUSE_ADDRESS, Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> SETTING_HTTP_TCP_SEND_BUFFER_SIZE = Setting.byteSizeSetting("http.tcp.send_buffer_size", NetworkService.TCP_SEND_BUFFER_SIZE, Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> SETTING_HTTP_TCP_RECEIVE_BUFFER_SIZE = Setting.byteSizeSetting("http.tcp.receive_buffer_size", NetworkService.TCP_RECEIVE_BUFFER_SIZE, Setting.Property.NodeScope);
    public static final Setting<List<String>> SETTING_HTTP_TRACE_LOG_INCLUDE = Setting.stringListSetting("http.tracer.include", Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<List<String>> SETTING_HTTP_TRACE_LOG_EXCLUDE = Setting.stringListSetting("http.tracer.exclude", Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Boolean> SETTING_HTTP_CLIENT_STATS_ENABLED = Setting.boolSetting("http.client_stats.enabled", true, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Integer> SETTING_HTTP_CLIENT_STATS_MAX_CLOSED_CHANNEL_COUNT = Setting.intSetting("http.client_stats.closed_channels.max_count", 10000, Setting.Property.NodeScope);
    public static final Setting<TimeValue> SETTING_HTTP_CLIENT_STATS_MAX_CLOSED_CHANNEL_AGE = Setting.timeSetting("http.client_stats.closed_channels.max_age", TimeValue.timeValueMinutes(5L), Setting.Property.NodeScope);

    private HttpTransportSettings() {
    }
}

