/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.network.HandlingTimeTracker;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.http.HttpRouteStatsTracker;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public record HttpRouteStats(long requestCount, long totalRequestSize, long[] requestSizeHistogram, long responseCount, long totalResponseSize, long[] responseSizeHistogram, long[] responseTimeHistogram) implements Writeable,
ToXContentObject
{
    public HttpRouteStats(StreamInput in) throws IOException {
        this(in.readVLong(), in.readVLong(), in.readVLongArray(), in.readVLong(), in.readVLong(), in.readVLongArray(), in.readVLongArray());
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject("requests");
        builder.field("count", this.requestCount);
        builder.humanReadableField("total_size_in_bytes", "total_size", ByteSizeValue.ofBytes(this.totalRequestSize));
        HttpRouteStats.histogramToXContent(builder, "size_histogram", "bytes", ByteSizeValue::ofBytes, this.requestSizeHistogram, HttpRouteStatsTracker.getBucketUpperBounds());
        builder.endObject();
        builder.startObject("responses");
        builder.field("count", this.responseCount);
        builder.humanReadableField("total_size_in_bytes", "total_size", ByteSizeValue.ofBytes(this.totalResponseSize));
        HttpRouteStats.histogramToXContent(builder, "size_histogram", "bytes", ByteSizeValue::ofBytes, this.responseSizeHistogram, HttpRouteStatsTracker.getBucketUpperBounds());
        HttpRouteStats.histogramToXContent(builder, "handling_time_histogram", "millis", TimeValue::timeValueMillis, this.responseTimeHistogram, HandlingTimeTracker.getBucketUpperBounds());
        builder.endObject();
        return builder.endObject();
    }

    static void histogramToXContent(XContentBuilder builder, String fieldName, String unitName, Function<Integer, Object> humanReadableValueFunc, long[] histogram, int[] bucketBounds) throws IOException {
        int i;
        assert (histogram.length == bucketBounds.length + 1);
        builder.startArray(fieldName);
        int firstBucket = 0;
        long remainingCount = 0L;
        for (i = 0; i < histogram.length; ++i) {
            if (remainingCount == 0L) {
                firstBucket = i;
            }
            remainingCount += histogram[i];
        }
        for (i = firstBucket; i < histogram.length && 0L < remainingCount; remainingCount -= histogram[i], ++i) {
            builder.startObject();
            if (i > 0) {
                builder.humanReadableField("ge_" + unitName, "ge", humanReadableValueFunc.apply(bucketBounds[i - 1]));
            }
            if (i < bucketBounds.length) {
                builder.humanReadableField("lt_" + unitName, "lt", humanReadableValueFunc.apply(bucketBounds[i]));
            }
            builder.field("count", histogram[i]);
            builder.endObject();
        }
        builder.endArray();
    }

    public static HttpRouteStats merge(HttpRouteStats first, HttpRouteStats second) {
        assert (first.requestSizeHistogram.length == second.requestSizeHistogram.length && first.responseSizeHistogram.length == second.responseSizeHistogram.length && first.responseTimeHistogram.length == second.responseTimeHistogram.length);
        return new HttpRouteStats(first.requestCount + second.requestCount, first.totalRequestSize + second.totalRequestSize, IntStream.range(0, first.requestSizeHistogram.length).mapToLong(i -> first.requestSizeHistogram[i] + second.requestSizeHistogram[i]).toArray(), first.responseCount + second.responseCount, first.totalResponseSize + second.totalResponseSize, IntStream.range(0, first.responseSizeHistogram.length).mapToLong(i -> first.responseSizeHistogram[i] + second.responseSizeHistogram[i]).toArray(), IntStream.range(0, first.responseTimeHistogram.length).mapToLong(i -> first.responseTimeHistogram[i] + second.responseTimeHistogram[i]).toArray());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.requestCount);
        out.writeVLong(this.totalRequestSize);
        out.writeVLongArray(this.requestSizeHistogram);
        out.writeVLong(this.responseCount);
        out.writeVLong(this.totalResponseSize);
        out.writeVLongArray(this.responseSizeHistogram);
        out.writeVLongArray(this.responseTimeHistogram);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpRouteStats that = (HttpRouteStats)o;
        return this.requestCount == that.requestCount && this.totalRequestSize == that.totalRequestSize && this.responseCount == that.responseCount && this.totalResponseSize == that.totalResponseSize && Arrays.equals(this.requestSizeHistogram, that.requestSizeHistogram) && Arrays.equals(this.responseSizeHistogram, that.responseSizeHistogram) && Arrays.equals(this.responseTimeHistogram, that.responseTimeHistogram);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(this.requestCount, this.totalRequestSize, this.responseCount, this.totalResponseSize);
        result = 31 * result + Arrays.hashCode(this.requestSizeHistogram);
        result = 31 * result + Arrays.hashCode(this.responseSizeHistogram);
        result = 31 * result + Arrays.hashCode(this.responseTimeHistogram);
        return result;
    }
}

