/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.health;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.client.internal.ParentTaskAssigningClient;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.health.HealthIndicatorResult;
import org.elasticsearch.health.HealthService;
import org.elasticsearch.health.HealthStatus;
import org.elasticsearch.health.stats.HealthApiStats;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.ToXContent;

public class GetHealthAction
extends ActionType<Response> {
    public static final GetHealthAction INSTANCE = new GetHealthAction();
    public static final String NAME = "cluster:monitor/health_api";

    private GetHealthAction() {
        super(NAME);
    }

    public static class LocalAction
    extends TransportAction<Request, Response> {
        private final ClusterService clusterService;
        private final HealthService healthService;
        private final NodeClient client;
        private final HealthApiStats healthApiStats;

        @Inject
        public LocalAction(ActionFilters actionFilters, TransportService transportService, ClusterService clusterService, HealthService healthService, NodeClient client, HealthApiStats healthApiStats) {
            super(GetHealthAction.NAME, actionFilters, transportService.getTaskManager());
            this.clusterService = clusterService;
            this.healthService = healthService;
            this.client = client;
            this.healthApiStats = healthApiStats;
        }

        @Override
        protected void doExecute(Task task, Request request, ActionListener<Response> responseListener) {
            assert (task instanceof CancellableTask);
            CancellableTask cancellableTask = (CancellableTask)task;
            if (cancellableTask.notifyIfCancelled(responseListener)) {
                return;
            }
            this.healthService.getHealth(new ParentTaskAssigningClient(this.client, this.clusterService.localNode(), task), request.indicatorName, request.verbose, request.size, responseListener.map(healthIndicatorResults -> {
                Response response = new Response(this.clusterService.getClusterName(), (List<HealthIndicatorResult>)healthIndicatorResults, request.indicatorName == null);
                this.healthApiStats.track(request.verbose, response);
                return response;
            }));
        }
    }

    public static class Request
    extends ActionRequest {
        private final String indicatorName;
        private final boolean verbose;
        private final int size;

        public Request(boolean verbose, int size) {
            this(null, verbose, size);
        }

        public Request(String indicatorName, boolean verbose, int size) {
            this.indicatorName = indicatorName;
            this.verbose = verbose;
            this.size = size;
        }

        @Override
        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (this.size < 0) {
                validationException = ValidateActions.addValidationError("The size parameter must be a positive integer", validationException);
            }
            return validationException;
        }

        @Override
        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new CancellableTask(id, type, action, "", parentTaskId, headers);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            TransportAction.localOnly();
        }
    }

    public static class Response
    extends ActionResponse
    implements ChunkedToXContent {
        private final ClusterName clusterName;
        @Nullable
        private final HealthStatus status;
        private final List<HealthIndicatorResult> indicators;

        public Response(ClusterName clusterName, List<HealthIndicatorResult> indicators, boolean showTopLevelStatus) {
            this.indicators = indicators;
            this.clusterName = clusterName;
            this.status = showTopLevelStatus ? HealthStatus.merge(indicators.stream().map(HealthIndicatorResult::status)) : null;
        }

        public Response(ClusterName clusterName, List<HealthIndicatorResult> indicators, HealthStatus topLevelStatus) {
            this.indicators = indicators;
            this.clusterName = clusterName;
            this.status = topLevelStatus;
        }

        public ClusterName getClusterName() {
            return this.clusterName;
        }

        public HealthStatus getStatus() {
            return this.status;
        }

        public HealthIndicatorResult findIndicator(String name) {
            return this.indicators.stream().filter(c -> Objects.equals(c.name(), name)).findFirst().orElseThrow(() -> new NoSuchElementException("Indicator [" + name + "] is not found"));
        }

        public List<HealthIndicatorResult> getIndicatorResults() {
            return this.indicators;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            TransportAction.localOnly();
        }

        @Override
        public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params outerParams) {
            return Iterators.concat(Iterators.single((builder, params) -> {
                builder.startObject();
                if (this.status != null) {
                    builder.field("status", this.status.xContentValue());
                }
                builder.field("cluster_name", this.clusterName.value());
                builder.startObject("indicators");
                return builder;
            }), Iterators.concat((Iterator[])this.indicators.stream().map(indicator -> Iterators.concat(Iterators.single((builder, params) -> builder.field(indicator.name())), indicator.toXContentChunked(outerParams))).toArray(Iterator[]::new)), Iterators.single((b, p) -> b.endObject().endObject()));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)o;
            return this.clusterName.equals(response.clusterName) && this.status == response.status && this.indicators.equals(response.indicators);
        }

        public int hashCode() {
            return Objects.hash(this.clusterName, this.status, this.indicators);
        }

        public String toString() {
            return "Response{clusterName=" + this.clusterName + ", status=" + this.status + ", indicatorResults=" + this.indicators + "}";
        }
    }
}

