/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.util.function.Supplier;

public final class CachedSupplier<T>
implements Supplier<T> {
    private volatile Supplier<T> supplier;
    private volatile T result;

    public static <R> CachedSupplier<R> wrap(Supplier<R> supplier) {
        if (supplier instanceof CachedSupplier) {
            CachedSupplier c = (CachedSupplier)supplier;
            return c;
        }
        return new CachedSupplier<R>(supplier);
    }

    private CachedSupplier(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    @Override
    public T get() {
        if (this.supplier == null) {
            return this.result;
        }
        this.initResult();
        return this.result;
    }

    private synchronized void initResult() {
        if (this.supplier != null) {
            this.result = this.supplier.get();
            this.supplier = null;
        }
    }
}

