/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io.stream;

import java.io.IOException;
import java.io.OutputStream;
import org.elasticsearch.common.io.stream.OutputStreamStreamOutput;

public class PositionTrackingOutputStreamStreamOutput
extends OutputStreamStreamOutput {
    private long position;

    public PositionTrackingOutputStreamStreamOutput(OutputStream out) {
        super(out);
    }

    @Override
    public void writeByte(byte b) throws IOException {
        super.writeByte(b);
        ++this.position;
    }

    @Override
    public void writeBytes(byte[] b, int offset, int length) throws IOException {
        super.writeBytes(b, offset, length);
        this.position += (long)length;
    }

    @Override
    public long position() throws IOException {
        return this.position;
    }
}

