/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.filesystem;

import com.sun.jna.LastErrorException;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Structure;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.OptionalLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.Constants;
import org.elasticsearch.common.filesystem.FileSystemNatives;
import org.elasticsearch.core.Strings;

final class LinuxFileSystemNatives
implements FileSystemNatives.Provider {
    private static final Logger logger = LogManager.getLogger(LinuxFileSystemNatives.class);
    private static final LinuxFileSystemNatives INSTANCE = new LinuxFileSystemNatives();
    private static final long ST_BLOCKS_UNIT = 512L;
    private static final int STAT_VER = LinuxFileSystemNatives.loadStatVersion();

    private static int loadStatVersion() {
        return "aarch64".equalsIgnoreCase(Constants.OS_ARCH) ? 0 : 1;
    }

    private LinuxFileSystemNatives() {
        assert (Constants.LINUX) : Constants.OS_NAME;
        assert (Constants.JRE_IS_64BIT) : Constants.OS_ARCH;
        try {
            Native.register(XStatLibrary.class, (String)Platform.C_LIBRARY_NAME);
            logger.debug("C library loaded");
        }
        catch (LinkageError e) {
            logger.warn("unable to link C library. native methods and handlers will be disabled.", (Throwable)e);
            throw e;
        }
    }

    static LinuxFileSystemNatives getInstance() {
        return INSTANCE;
    }

    @Override
    public OptionalLong allocatedSizeInBytes(Path path) {
        assert (Files.isRegularFile(path, new LinkOption[0])) : path;
        try {
            Stat stats = new Stat();
            int rc = XStatLibrary.__xstat(STAT_VER, path.toString(), stats);
            if (logger.isTraceEnabled()) {
                logger.trace("executing native method __xstat() returned {} with error code [{}] for file [{}]", (Object)stats, (Object)rc, (Object)path);
            }
            return OptionalLong.of(stats.st_blocks * 512L);
        }
        catch (LastErrorException e) {
            logger.warn(() -> Strings.format("error when executing native method __xstat(int vers, const char *name, struct stat *buf) for file [%s]", path), (Throwable)e);
            return OptionalLong.empty();
        }
    }

    public static class XStatLibrary {
        public static native int __xstat(int var0, String var1, Stat var2) throws LastErrorException;
    }

    @Structure.FieldOrder(value={"st_dev", "st_ino", "st_nlink", "st_mode", "st_uid", "st_gid", "__pad0", "st_rdev", "st_size", "st_blksize", "st_blocks", "st_atim", "st_mtim", "st_ctim", "__glibc_reserved0", "__glibc_reserved1", "__glibc_reserved2"})
    public static class Stat
    extends Structure {
        public long st_dev;
        public long st_ino;
        public long st_nlink;
        public int st_mode;
        public int st_uid;
        public int st_gid;
        public int __pad0;
        public long st_rdev;
        public long st_size;
        public long st_blksize;
        public long st_blocks;
        public Time st_atim;
        public Time st_mtim;
        public Time st_ctim;
        public long __glibc_reserved0;
        public long __glibc_reserved1;
        public long __glibc_reserved2;

        public String toString() {
            return "[st_dev=" + this.st_dev + ", st_ino=" + this.st_ino + ", st_nlink=" + this.st_nlink + ", st_mode=" + this.st_mode + ", st_uid=" + this.st_uid + ", st_gid=" + this.st_gid + ", st_rdev=" + this.st_rdev + ", st_size=" + this.st_size + ", st_blksize=" + this.st_blksize + ", st_blocks=" + this.st_blocks + ", st_atim=" + Instant.ofEpochSecond(this.st_atim.tv_sec, this.st_atim.tv_nsec) + ", st_mtim=" + Instant.ofEpochSecond(this.st_mtim.tv_sec, this.st_mtim.tv_nsec) + ", st_ctim=" + Instant.ofEpochSecond(this.st_ctim.tv_sec, this.st_ctim.tv_nsec) + "]";
        }
    }

    @Structure.FieldOrder(value={"tv_sec", "tv_nsec"})
    public static class Time
    extends Structure {
        public long tv_sec;
        public long tv_nsec;
    }
}

