/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.file;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.file.AbstractFileWatchingService;

public abstract class MasterNodeFileWatchingService
extends AbstractFileWatchingService
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(MasterNodeFileWatchingService.class);
    private final ClusterService clusterService;
    private volatile boolean active = false;

    protected MasterNodeFileWatchingService(ClusterService clusterService, Path watchedFile) {
        super(watchedFile);
        this.clusterService = clusterService;
    }

    @Override
    protected void doStart() {
        this.active = Files.exists(this.watchedFileDir().getParent(), new LinkOption[0]);
        if (!this.active) {
            return;
        }
        if (DiscoveryNode.isMasterNode(this.clusterService.getSettings())) {
            this.clusterService.addListener(this);
        }
    }

    @Override
    protected void doStop() {
        this.active = false;
        super.doStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void clusterChanged(ClusterChangedEvent event) {
        ClusterState clusterState = event.state();
        if (clusterState.nodes().isLocalNodeElectedMaster()) {
            MasterNodeFileWatchingService masterNodeFileWatchingService = this;
            synchronized (masterNodeFileWatchingService) {
                if (this.watching() || !this.active) {
                    this.refreshExistingFileStateIfNeeded(clusterState);
                    return;
                }
                this.startWatcher();
            }
        } else if (event.previousState().nodes().isLocalNodeElectedMaster()) {
            this.stopWatcher();
        }
    }

    private void refreshExistingFileStateIfNeeded(ClusterState clusterState) {
        if (this.watching() && this.shouldRefreshFileState(clusterState) && Files.exists(this.watchedFile(), new LinkOption[0])) {
            try {
                Files.setLastModifiedTime(this.watchedFile(), FileTime.from(Instant.now()));
            }
            catch (IOException e) {
                logger.warn("encountered I/O error trying to update file settings timestamp", (Throwable)e);
            }
        }
    }

    protected boolean shouldRefreshFileState(ClusterState clusterState) {
        return false;
    }
}

