/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.elasticsearch.Build;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;

public final class ReferenceDocs
extends Enum<ReferenceDocs> {
    public static final /* enum */ ReferenceDocs INITIAL_MASTER_NODES = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs DISCOVERY_TROUBLESHOOTING = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs UNSTABLE_CLUSTER_TROUBLESHOOTING = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs LAGGING_NODE_TROUBLESHOOTING = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs SHARD_LOCK_TROUBLESHOOTING = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs CONCURRENT_REPOSITORY_WRITERS = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs ARCHIVE_INDICES = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs HTTP_TRACER = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs LOGGING = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs BOOTSTRAP_CHECK_HEAP_SIZE = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs BOOTSTRAP_CHECK_FILE_DESCRIPTOR = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs BOOTSTRAP_CHECK_MEMORY_LOCK = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs BOOTSTRAP_CHECK_MAX_NUMBER_THREADS = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs BOOTSTRAP_CHECK_MAX_FILE_SIZE = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs BOOTSTRAP_CHECK_MAX_SIZE_VIRTUAL_MEMORY = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs BOOTSTRAP_CHECK_MAXIMUM_MAP_COUNT = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs BOOTSTRAP_CHECK_CLIENT_JVM = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs BOOTSTRAP_CHECK_USE_SERIAL_COLLECTOR = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs BOOTSTRAP_CHECK_SYSTEM_CALL_FILTER = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs BOOTSTRAP_CHECK_ONERROR_AND_ONOUTOFMEMORYERROR = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs BOOTSTRAP_CHECK_EARLY_ACCESS = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs BOOTSTRAP_CHECK_G1GC = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs BOOTSTRAP_CHECK_ALL_PERMISSION = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs BOOTSTRAP_CHECK_DISCOVERY_CONFIGURATION = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs BOOTSTRAP_CHECKS = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs BOOTSTRAP_CHECK_ENCRYPT_SENSITIVE_DATA = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs BOOTSTRAP_CHECK_PKI_REALM = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs BOOTSTRAP_CHECK_ROLE_MAPPINGS = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs BOOTSTRAP_CHECK_TLS = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs BOOTSTRAP_CHECK_TOKEN_SSL = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs BOOTSTRAP_CHECK_SECURITY_MINIMAL_SETUP = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs CONTACT_SUPPORT = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs UNASSIGNED_SHARDS = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs EXECUTABLE_JNA_TMPDIR = new ReferenceDocs();
    private static final Map<String, String> linksBySymbol;
    static final String UNRELEASED_VERSION_COMPONENT = "master";
    static final String CURRENT_VERSION_COMPONENT = "current";
    static final String VERSION_COMPONENT;
    private static final /* synthetic */ ReferenceDocs[] $VALUES;

    public static ReferenceDocs[] values() {
        return (ReferenceDocs[])$VALUES.clone();
    }

    public static ReferenceDocs valueOf(String name) {
        return Enum.valueOf(ReferenceDocs.class, name);
    }

    static Map<String, String> readLinksBySymbol(InputStream inputStream) throws Exception {
        try (XContentParser parser = XContentFactory.xContent(XContentType.JSON).createParser(XContentParserConfiguration.EMPTY, inputStream);){
            Map<String, String> result = parser.map(LinkedHashMap::new, XContentParser::text);
            Iterator<String> iterator = result.keySet().iterator();
            for (int i = 0; i < ReferenceDocs.values().length; ++i) {
                String expected = ReferenceDocs.values()[i].name();
                if (!iterator.hasNext()) {
                    throw new IllegalStateException("ran out of values at index " + i + ": expecting " + expected);
                }
                String actual = iterator.next();
                if (actual.equals(expected)) continue;
                throw new IllegalStateException("mismatch at index " + i + ": found " + actual + " but expected " + expected);
            }
            if (iterator.hasNext()) {
                throw new IllegalStateException("found unexpected extra value: " + iterator.next());
            }
            Map<String, String> map = result;
            return map;
        }
    }

    static String getVersionComponent(String version, boolean isSnapshot) {
        Pattern semanticVersionPattern = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d)+");
        Matcher matcher = semanticVersionPattern.matcher(version);
        if (matcher.matches()) {
            String major = matcher.group(1);
            String minor = matcher.group(2);
            String revision = matcher.group(3);
            if (isSnapshot && "0".equals(revision)) {
                return UNRELEASED_VERSION_COMPONENT;
            }
            return major + "." + minor;
        }
        if (isSnapshot) {
            return UNRELEASED_VERSION_COMPONENT;
        }
        return CURRENT_VERSION_COMPONENT;
    }

    public String toString() {
        return "https://www.elastic.co/guide/en/elasticsearch/reference/" + VERSION_COMPONENT + "/" + linksBySymbol.get(this.name());
    }

    @SuppressForbidden(reason="reads resource from jar")
    private static InputStream readFromJarResourceUrl(URL source) throws IOException {
        if (source == null) {
            throw new FileNotFoundException("links resource not found at [" + source + "]");
        }
        return source.openStream();
    }

    private static /* synthetic */ ReferenceDocs[] $values() {
        return new ReferenceDocs[]{INITIAL_MASTER_NODES, DISCOVERY_TROUBLESHOOTING, UNSTABLE_CLUSTER_TROUBLESHOOTING, LAGGING_NODE_TROUBLESHOOTING, SHARD_LOCK_TROUBLESHOOTING, CONCURRENT_REPOSITORY_WRITERS, ARCHIVE_INDICES, HTTP_TRACER, LOGGING, BOOTSTRAP_CHECK_HEAP_SIZE, BOOTSTRAP_CHECK_FILE_DESCRIPTOR, BOOTSTRAP_CHECK_MEMORY_LOCK, BOOTSTRAP_CHECK_MAX_NUMBER_THREADS, BOOTSTRAP_CHECK_MAX_FILE_SIZE, BOOTSTRAP_CHECK_MAX_SIZE_VIRTUAL_MEMORY, BOOTSTRAP_CHECK_MAXIMUM_MAP_COUNT, BOOTSTRAP_CHECK_CLIENT_JVM, BOOTSTRAP_CHECK_USE_SERIAL_COLLECTOR, BOOTSTRAP_CHECK_SYSTEM_CALL_FILTER, BOOTSTRAP_CHECK_ONERROR_AND_ONOUTOFMEMORYERROR, BOOTSTRAP_CHECK_EARLY_ACCESS, BOOTSTRAP_CHECK_G1GC, BOOTSTRAP_CHECK_ALL_PERMISSION, BOOTSTRAP_CHECK_DISCOVERY_CONFIGURATION, BOOTSTRAP_CHECKS, BOOTSTRAP_CHECK_ENCRYPT_SENSITIVE_DATA, BOOTSTRAP_CHECK_PKI_REALM, BOOTSTRAP_CHECK_ROLE_MAPPINGS, BOOTSTRAP_CHECK_TLS, BOOTSTRAP_CHECK_TOKEN_SSL, BOOTSTRAP_CHECK_SECURITY_MINIMAL_SETUP, CONTACT_SUPPORT, UNASSIGNED_SHARDS, EXECUTABLE_JNA_TMPDIR};
    }

    static {
        $VALUES = ReferenceDocs.$values();
        try (InputStream resourceStream = ReferenceDocs.readFromJarResourceUrl(ReferenceDocs.class.getResource("reference-docs-links.json"));){
            linksBySymbol = Map.copyOf(ReferenceDocs.readLinksBySymbol(resourceStream));
        }
        catch (Exception e) {
            assert (false) : e;
            throw new IllegalStateException("could not read links resource", e);
        }
        VERSION_COMPONENT = ReferenceDocs.getVersionComponent(Build.current().version(), Build.current().isSnapshot());
    }
}

