/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common;

import java.util.Arrays;
import java.util.Base64;
import java.util.Random;
import org.elasticsearch.common.SecureRandomHolder;
import org.elasticsearch.common.UUIDGenerator;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.core.CharArrays;

class RandomBasedUUIDGenerator
implements UUIDGenerator {
    RandomBasedUUIDGenerator() {
    }

    @Override
    public String getBase64UUID() {
        return RandomBasedUUIDGenerator.getBase64UUID(SecureRandomHolder.INSTANCE);
    }

    public static SecureString getBase64UUIDSecureString() {
        byte[] uuidBytes = null;
        byte[] encodedBytes = null;
        try {
            uuidBytes = RandomBasedUUIDGenerator.getUUIDBytes(SecureRandomHolder.INSTANCE);
            encodedBytes = Base64.getUrlEncoder().withoutPadding().encode(uuidBytes);
            SecureString secureString = new SecureString(CharArrays.utf8BytesToChars(encodedBytes));
            return secureString;
        }
        finally {
            if (uuidBytes != null) {
                Arrays.fill(uuidBytes, (byte)0);
            }
            if (encodedBytes != null) {
                Arrays.fill(encodedBytes, (byte)0);
            }
        }
    }

    public static String getBase64UUID(Random random) {
        return Base64.getUrlEncoder().withoutPadding().encodeToString(RandomBasedUUIDGenerator.getUUIDBytes(random));
    }

    private static byte[] getUUIDBytes(Random random) {
        byte[] randomBytes = new byte[16];
        random.nextBytes(randomBytes);
        randomBytes[6] = (byte)(randomBytes[6] & 0xF);
        randomBytes[6] = (byte)(randomBytes[6] | 0x40);
        randomBytes[8] = (byte)(randomBytes[8] & 0x3F);
        randomBytes[8] = (byte)(randomBytes[8] | 0xFFFFFF80);
        return randomBytes;
    }
}

