/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class IndexWriteLoad
implements Writeable,
ToXContentFragment {
    public static final ParseField SHARDS_WRITE_LOAD_FIELD = new ParseField("loads", new String[0]);
    public static final ParseField SHARDS_UPTIME_IN_MILLIS = new ParseField("uptimes", new String[0]);
    private static final Double UNKNOWN_LOAD = -1.0;
    private static final long UNKNOWN_UPTIME = -1L;
    private static final ConstructingObjectParser<IndexWriteLoad, Void> PARSER = new ConstructingObjectParser<IndexWriteLoad, Void>("index_write_load_parser", false, (args, unused) -> IndexWriteLoad.create((List)args[0], (List)args[1]));
    private final double[] shardWriteLoad;
    private final long[] shardUptimeInMillis;

    public static IndexWriteLoad create(List<Double> shardsWriteLoad, List<Long> shardsUptimeInMillis) {
        if (shardsWriteLoad.size() != shardsUptimeInMillis.size()) {
            assert (false);
            throw new IllegalArgumentException("The same number of shard write loads and shard uptimes should be provided, but " + shardsWriteLoad + " " + shardsUptimeInMillis + " were provided");
        }
        if (shardsWriteLoad.isEmpty()) {
            assert (false);
            throw new IllegalArgumentException("At least one shard write load and uptime should be provided, but none was provided");
        }
        return new IndexWriteLoad(shardsWriteLoad.stream().mapToDouble(shardLoad -> shardLoad).toArray(), shardsUptimeInMillis.stream().mapToLong(shardUptime -> shardUptime).toArray());
    }

    private IndexWriteLoad(double[] shardWriteLoad, long[] shardUptimeInMillis) {
        assert (shardWriteLoad.length == shardUptimeInMillis.length);
        this.shardWriteLoad = shardWriteLoad;
        this.shardUptimeInMillis = shardUptimeInMillis;
    }

    public IndexWriteLoad(StreamInput in) throws IOException {
        this(in.readDoubleArray(), in.readLongArray());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeDoubleArray(this.shardWriteLoad);
        out.writeLongArray(this.shardUptimeInMillis);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(SHARDS_WRITE_LOAD_FIELD.getPreferredName(), this.shardWriteLoad);
        builder.field(SHARDS_UPTIME_IN_MILLIS.getPreferredName(), this.shardUptimeInMillis);
        return builder;
    }

    public static IndexWriteLoad fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    public OptionalDouble getWriteLoadForShard(int shardId) {
        this.assertShardInBounds(shardId);
        double load = this.shardWriteLoad[shardId];
        return load != UNKNOWN_LOAD ? OptionalDouble.of(load) : OptionalDouble.empty();
    }

    public OptionalLong getUptimeInMillisForShard(int shardId) {
        this.assertShardInBounds(shardId);
        long uptime = this.shardUptimeInMillis[shardId];
        return uptime != -1L ? OptionalLong.of(uptime) : OptionalLong.empty();
    }

    public int numberOfShards() {
        return this.shardWriteLoad.length;
    }

    private void assertShardInBounds(int shardId) {
        assert (shardId >= 0) : "Unexpected shard id " + shardId;
        assert (shardId < this.shardWriteLoad.length) : "Unexpected shard id " + shardId + ", expected < " + this.shardWriteLoad.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexWriteLoad that = (IndexWriteLoad)o;
        return Arrays.equals(this.shardWriteLoad, that.shardWriteLoad) && Arrays.equals(this.shardUptimeInMillis, that.shardUptimeInMillis);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.shardWriteLoad);
        result = 31 * result + Arrays.hashCode(this.shardUptimeInMillis);
        return result;
    }

    public static Builder builder(int numShards) {
        assert (numShards > 0) : "A positive number of shards should be provided";
        return new Builder(numShards);
    }

    static {
        PARSER.declareDoubleArray(ConstructingObjectParser.constructorArg(), SHARDS_WRITE_LOAD_FIELD);
        PARSER.declareLongArray(ConstructingObjectParser.constructorArg(), SHARDS_UPTIME_IN_MILLIS);
    }

    public static class Builder {
        final double[] shardWriteLoad;
        final long[] uptimeInMillis;

        private Builder(int numShards) {
            this.shardWriteLoad = new double[numShards];
            this.uptimeInMillis = new long[numShards];
            Arrays.fill(this.shardWriteLoad, UNKNOWN_LOAD);
            Arrays.fill(this.uptimeInMillis, -1L);
        }

        public Builder withShardWriteLoad(int shardId, double load, long uptimeInMillis) {
            if (shardId >= this.shardWriteLoad.length) {
                throw new IllegalArgumentException();
            }
            this.shardWriteLoad[shardId] = load;
            this.uptimeInMillis[shardId] = uptimeInMillis;
            return this;
        }

        public IndexWriteLoad build() {
            return new IndexWriteLoad(this.shardWriteLoad, this.uptimeInMillis);
        }
    }
}

