/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.similarities.BM25Similarity;
import org.apache.lucene.search.similarities.Similarity;
import org.elasticsearch.Build;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.TriFunction;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.core.Strings;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.analysis.AnalyzerScope;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.mapper.MapperRegistry;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.similarity.SimilarityService;
import org.elasticsearch.script.ScriptCompiler;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentParserConfiguration;

public class IndexMetadataVerifier {
    private static final Logger logger = LogManager.getLogger(IndexMetadataVerifier.class);
    private final Settings settings;
    private final ClusterService clusterService;
    private final XContentParserConfiguration parserConfiguration;
    private final MapperRegistry mapperRegistry;
    private final IndexScopedSettings indexScopedSettings;
    private final ScriptCompiler scriptService;

    public IndexMetadataVerifier(Settings settings, ClusterService clusterService, NamedXContentRegistry xContentRegistry, MapperRegistry mapperRegistry, IndexScopedSettings indexScopedSettings, ScriptCompiler scriptCompiler) {
        this.settings = settings;
        this.clusterService = clusterService;
        this.parserConfiguration = XContentParserConfiguration.EMPTY.withRegistry(xContentRegistry).withDeprecationHandler(LoggingDeprecationHandler.INSTANCE);
        this.mapperRegistry = mapperRegistry;
        this.indexScopedSettings = indexScopedSettings;
        this.scriptService = scriptCompiler;
    }

    public IndexMetadata verifyIndexMetadata(IndexMetadata indexMetadata, IndexVersion minimumIndexCompatibilityVersion) {
        IndexMetadataVerifier.checkSupportedVersion(indexMetadata, minimumIndexCompatibilityVersion);
        IndexMetadata newMetadata = IndexMetadataVerifier.convertSharedCacheTierPreference(indexMetadata);
        newMetadata = IndexMetadataVerifier.removeTierFiltering(newMetadata);
        newMetadata = this.archiveOrDeleteBrokenIndexSettings(newMetadata);
        this.checkMappingsCompatibility(newMetadata);
        return newMetadata;
    }

    private static void checkSupportedVersion(IndexMetadata indexMetadata, IndexVersion minimumIndexCompatibilityVersion) {
        boolean isSupportedVersion = indexMetadata.getCompatibilityVersion().onOrAfter(minimumIndexCompatibilityVersion);
        if (!isSupportedVersion) {
            throw new IllegalStateException("The index " + indexMetadata.getIndex() + " has current compatibility version [" + indexMetadata.getCompatibilityVersion().toReleaseVersion() + "] but the minimum compatible version is [" + minimumIndexCompatibilityVersion.toReleaseVersion() + "]. It should be re-indexed in Elasticsearch " + (Version.CURRENT.major - 1) + ".x before upgrading to " + Build.current().version() + ".");
        }
    }

    private void checkMappingsCompatibility(IndexMetadata indexMetadata) {
        try {
            IndexSettings indexSettings = new IndexSettings(indexMetadata, this.settings);
            AbstractMap<String, TriFunction<Settings, IndexVersion, ScriptService, Similarity>> similarityMap = new AbstractMap<String, TriFunction<Settings, IndexVersion, ScriptService, Similarity>>(){

                @Override
                public boolean containsKey(Object key) {
                    return true;
                }

                @Override
                public TriFunction<Settings, IndexVersion, ScriptService, Similarity> get(Object key) {
                    assert (key instanceof String) : "key must be a string but was: " + key.getClass();
                    return (settings, version, scriptService) -> new BM25Similarity();
                }

                @Override
                public Set<Map.Entry<String, TriFunction<Settings, IndexVersion, ScriptService, Similarity>>> entrySet() {
                    return Collections.emptySet();
                }
            };
            SimilarityService similarityService = new SimilarityService(indexSettings, null, (Map<String, TriFunction<Settings, IndexVersion, ScriptService, Similarity>>)similarityMap);
            NamedAnalyzer fakeDefault = new NamedAnalyzer("default", AnalyzerScope.INDEX, new Analyzer(){

                @Override
                protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                    throw new UnsupportedOperationException("shouldn't be here");
                }
            });
            try (MapperService mapperService = new MapperService(this.clusterService, indexSettings, (type, name) -> new NamedAnalyzer(name, AnalyzerScope.INDEX, fakeDefault.analyzer()), this.parserConfiguration, similarityService, this.mapperRegistry, () -> null, indexSettings.getMode().idFieldMapperWithoutFieldData(), this.scriptService);){
                mapperService.merge(indexMetadata, MapperService.MergeReason.MAPPING_RECOVERY);
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to parse mappings for index [" + indexMetadata.getIndex() + "]", ex);
        }
    }

    IndexMetadata archiveOrDeleteBrokenIndexSettings(IndexMetadata indexMetadata) {
        Settings settings = indexMetadata.getSettings();
        Settings newSettings = indexMetadata.isSystem() ? this.indexScopedSettings.deleteUnknownOrInvalidSettings(settings, e -> logger.warn("{} deleting unknown system index setting: [{}] with value [{}]", (Object)indexMetadata.getIndex(), e.getKey(), e.getValue()), (e, ex) -> logger.warn(() -> Strings.format("%s deleting invalid system index setting: [%s] with value [%s]", indexMetadata.getIndex(), e.getKey(), e.getValue()), (Throwable)ex)) : this.indexScopedSettings.archiveUnknownOrInvalidSettings(settings, e -> logger.warn("{} ignoring unknown index setting: [{}] with value [{}]; archiving", (Object)indexMetadata.getIndex(), e.getKey(), e.getValue()), (e, ex) -> logger.warn(() -> Strings.format("%s ignoring invalid index setting: [%s] with value [%s]; archiving", indexMetadata.getIndex(), e.getKey(), e.getValue()), (Throwable)ex));
        if (newSettings != settings) {
            return IndexMetadata.builder(indexMetadata).settings(newSettings).build();
        }
        return indexMetadata;
    }

    static IndexMetadata convertSharedCacheTierPreference(IndexMetadata indexMetadata) {
        if (indexMetadata.isPartialSearchableSnapshot()) {
            Settings settings = indexMetadata.getSettings();
            Settings.Builder settingsBuilder = Settings.builder().put(settings);
            settingsBuilder.remove("index.routing.allocation.include._tier");
            settingsBuilder.remove("index.routing.allocation.exclude._tier");
            settingsBuilder.remove("index.routing.allocation.require._tier");
            settingsBuilder.put("index.routing.allocation.include._tier_preference", "data_frozen");
            Settings newSettings = settingsBuilder.build();
            if (settings.equals(newSettings)) {
                return indexMetadata;
            }
            return IndexMetadata.builder(indexMetadata).settings(newSettings).build();
        }
        return indexMetadata;
    }

    static IndexMetadata removeTierFiltering(IndexMetadata indexMetadata) {
        Settings settings = indexMetadata.getSettings();
        Settings.Builder settingsBuilder = Settings.builder().put(settings);
        settingsBuilder.remove("index.routing.allocation.include._tier");
        settingsBuilder.remove("index.routing.allocation.exclude._tier");
        settingsBuilder.remove("index.routing.allocation.require._tier");
        Settings newSettings = settingsBuilder.build();
        if (settings.equals(newSettings)) {
            return indexMetadata;
        }
        return IndexMetadata.builder(indexMetadata).settings(newSettings).build();
    }
}

