/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.store.LockObtainFailedException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.admin.indices.rollover.Condition;
import org.elasticsearch.cli.ProcessInfo;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cli.UserException;
import org.elasticsearch.cluster.ClusterModule;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.cli.EnvironmentAwareCommand;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.env.NodeMetadata;
import org.elasticsearch.gateway.PersistedClusterStateService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public abstract class ElasticsearchNodeCommand
extends EnvironmentAwareCommand {
    private static final Logger logger = LogManager.getLogger(ElasticsearchNodeCommand.class);
    protected static final String DELIMITER = "------------------------------------------------------------------------\n";
    static final String STOP_WARNING_MSG = "------------------------------------------------------------------------\n\n    WARNING: Elasticsearch MUST be stopped before running this tool.\n";
    protected static final String FAILED_TO_OBTAIN_NODE_LOCK_MSG = "failed to lock node's directory, is Elasticsearch still running?";
    protected static final String ABORTED_BY_USER_MSG = "aborted by user";
    static final String NO_NODE_FOLDER_FOUND_MSG = "no node folder is found in data folder(s), node has not been started yet?";
    static final String NO_NODE_METADATA_FOUND_MSG = "no node meta data is found, node has not been started yet?";
    protected static final String CS_MISSING_MSG = "cluster state is empty, cluster has never been bootstrapped?";
    public static final NamedXContentRegistry namedXContentRegistry = new NamedXContentRegistry((List)ClusterModule.getNamedXWriteables()){

        @Override
        public <T, C> T parseNamedObject(Class<T> categoryClass, String name, XContentParser parser, C context) throws IOException {
            if (Metadata.Custom.class.isAssignableFrom(categoryClass)) {
                if ("data_stream".equals(name) || "index_template".equals(name) || "component_template".equals(name)) {
                    return super.parseNamedObject(categoryClass, name, parser, context);
                }
                return (T)new UnknownMetadataCustom(name, parser.mapOrdered());
            }
            if (Condition.class.isAssignableFrom(categoryClass)) {
                assert (parser.currentToken() == XContentParser.Token.FIELD_NAME) : parser.currentToken();
                if (parser.currentToken() != XContentParser.Token.FIELD_NAME) {
                    throw new UnsupportedOperationException("Unexpected token for Condition: " + parser.currentToken());
                }
                parser.nextToken();
                assert (parser.currentToken().isValue()) : parser.currentToken();
                if (!parser.currentToken().isValue()) {
                    throw new UnsupportedOperationException("Unexpected token for Condition: " + parser.currentToken());
                }
                return (T)new UnknownCondition(name, parser.objectText());
            }
            assert (false) : "Unexpected category class " + categoryClass + " for name " + name;
            throw new UnsupportedOperationException("Unexpected category class " + categoryClass + " for name " + name);
        }
    };

    public ElasticsearchNodeCommand(String description) {
        super(description);
    }

    public static PersistedClusterStateService createPersistedClusterStateService(Settings settings, Path[] dataPaths) throws IOException {
        NodeMetadata nodeMetadata = PersistedClusterStateService.nodeMetadata(dataPaths);
        if (nodeMetadata == null) {
            throw new ElasticsearchException(NO_NODE_METADATA_FOUND_MSG, new Object[0]);
        }
        String nodeId = nodeMetadata.nodeId();
        return new PersistedClusterStateService(dataPaths, nodeId, namedXContentRegistry, new ClusterSettings(settings, ClusterSettings.BUILT_IN_CLUSTER_SETTINGS), () -> 0L);
    }

    public static ClusterState clusterState(Environment environment, PersistedClusterStateService.OnDiskState onDiskState) {
        return ClusterState.builder(ClusterName.CLUSTER_NAME_SETTING.get(environment.settings())).version(onDiskState.lastAcceptedVersion).metadata(onDiskState.metadata).build();
    }

    public static Tuple<Long, ClusterState> loadTermAndClusterState(PersistedClusterStateService psf, Environment env) throws IOException {
        PersistedClusterStateService.OnDiskState bestOnDiskState = psf.loadBestOnDiskState();
        if (bestOnDiskState.empty()) {
            throw new ElasticsearchException(CS_MISSING_MSG, new Object[0]);
        }
        return Tuple.tuple(bestOnDiskState.currentTerm, ElasticsearchNodeCommand.clusterState(env, bestOnDiskState));
    }

    protected void processDataPaths(Terminal terminal, OptionSet options, Environment env) throws IOException, UserException {
        terminal.println(Terminal.Verbosity.VERBOSE, (CharSequence)"Obtaining lock for node");
        try (NodeEnvironment.NodeLock lock = new NodeEnvironment.NodeLock(logger, env, x$0 -> Files.exists(x$0, new LinkOption[0]));){
            Path[] dataPaths = (Path[])Arrays.stream(lock.getDataPaths()).filter(Objects::nonNull).map(p -> p.path).toArray(Path[]::new);
            if (dataPaths.length == 0) {
                throw new ElasticsearchException(NO_NODE_FOLDER_FOUND_MSG, new Object[0]);
            }
            this.processDataPaths(terminal, dataPaths, options, env);
        }
        catch (LockObtainFailedException e) {
            throw new ElasticsearchException(FAILED_TO_OBTAIN_NODE_LOCK_MSG, (Throwable)e, new Object[0]);
        }
    }

    protected static void confirm(Terminal terminal, String msg) {
        terminal.println((CharSequence)msg);
        String text = terminal.readText("Confirm [y/N] ");
        if (!text.equalsIgnoreCase("y")) {
            throw new ElasticsearchException(ABORTED_BY_USER_MSG, new Object[0]);
        }
    }

    @Override
    public final void execute(Terminal terminal, OptionSet options, Environment env, ProcessInfo processInfo) throws Exception {
        terminal.println((CharSequence)STOP_WARNING_MSG);
        if (this.validateBeforeLock(terminal, env)) {
            this.processDataPaths(terminal, options, env);
        }
    }

    protected boolean validateBeforeLock(Terminal terminal, Environment env) {
        return true;
    }

    protected abstract void processDataPaths(Terminal var1, Path[] var2, OptionSet var3, Environment var4) throws IOException, UserException;

    protected static NodeEnvironment.DataPath[] toDataPaths(Path[] paths) {
        return (NodeEnvironment.DataPath[])Arrays.stream(paths).map(ElasticsearchNodeCommand::createDataPath).toArray(NodeEnvironment.DataPath[]::new);
    }

    private static NodeEnvironment.DataPath createDataPath(Path path) {
        try {
            return new NodeEnvironment.DataPath(path);
        }
        catch (IOException e) {
            throw new ElasticsearchException("Unable to investigate path [" + path + "]", (Throwable)e, new Object[0]);
        }
    }

    OptionParser getParser() {
        return this.parser;
    }

    public static class UnknownCondition
    extends Condition<Object> {
        public UnknownCondition(String name, Object value) {
            super(name, null);
            this.value = value;
        }

        @Override
        public String getWriteableName() {
            return this.name;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            assert (false);
            throw new UnsupportedOperationException();
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.field(this.name, this.value);
        }

        @Override
        public Condition.Result evaluate(Condition.Stats stats) {
            assert (false);
            throw new UnsupportedOperationException();
        }

        @Override
        public Condition.Type type() {
            assert (false);
            throw new UnsupportedOperationException();
        }
    }

    public record UnknownMetadataCustom(String name, Map<String, Object> contents) implements Metadata.Custom
    {
        @Override
        public EnumSet<Metadata.XContentContext> context() {
            return EnumSet.of(Metadata.XContentContext.API, Metadata.XContentContext.GATEWAY);
        }

        @Override
        public Diff<Metadata.Custom> diff(Metadata.Custom previousState) {
            assert (false);
            throw new UnsupportedOperationException();
        }

        @Override
        public String getWriteableName() {
            return this.name;
        }

        @Override
        public TransportVersion getMinimalSupportedVersion() {
            assert (false);
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            assert (false);
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params ignored) {
            return Iterators.single((builder, params) -> builder.mapContents(this.contents));
        }
    }
}

