/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.tasks;

import java.io.IOException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;

public class BaseTasksRequest<Request extends BaseTasksRequest<Request>>
extends ActionRequest {
    public static final String[] ALL_ACTIONS = Strings.EMPTY_ARRAY;
    public static final String[] ALL_NODES = Strings.EMPTY_ARRAY;
    private String[] nodes = ALL_NODES;
    private TimeValue timeout;
    private String[] actions = ALL_ACTIONS;
    private TaskId targetParentTaskId = TaskId.EMPTY_TASK_ID;
    private TaskId targetTaskId = TaskId.EMPTY_TASK_ID;

    public BaseTasksRequest() {
    }

    protected BaseTasksRequest(StreamInput in) throws IOException {
        super(in);
        this.targetTaskId = TaskId.readFromStream(in);
        this.targetParentTaskId = TaskId.readFromStream(in);
        this.nodes = in.readStringArray();
        this.actions = in.readStringArray();
        this.timeout = in.readOptionalTimeValue();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.targetTaskId.writeTo(out);
        this.targetParentTaskId.writeTo(out);
        out.writeStringArrayNullable(this.nodes);
        out.writeStringArrayNullable(this.actions);
        out.writeOptionalTimeValue(this.timeout);
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.targetTaskId.isSet() && this.nodes.length > 0) {
            validationException = ValidateActions.addValidationError("task id cannot be used together with node ids", validationException);
        }
        return validationException;
    }

    public final Request setActions(String ... actions) {
        this.actions = actions;
        return (Request)this;
    }

    public String[] getActions() {
        return this.actions;
    }

    public final String[] getNodes() {
        return this.nodes;
    }

    public final Request setNodes(String ... nodes) {
        this.nodes = nodes;
        return (Request)this;
    }

    public TaskId getTargetTaskId() {
        return this.targetTaskId;
    }

    public final Request setTargetTaskId(TaskId targetTaskId) {
        this.targetTaskId = targetTaskId;
        return (Request)this;
    }

    @Deprecated
    public TaskId getTaskId() {
        return this.getTargetTaskId();
    }

    @Deprecated
    public final Request setTaskId(TaskId taskId) {
        return this.setTargetTaskId(taskId);
    }

    public TaskId getTargetParentTaskId() {
        return this.targetParentTaskId;
    }

    public Request setTargetParentTaskId(TaskId targetParentTaskId) {
        this.targetParentTaskId = targetParentTaskId;
        return (Request)this;
    }

    @Deprecated
    public TaskId getParentTaskId() {
        return this.getTargetParentTaskId();
    }

    @Deprecated
    public Request setParentTaskId(TaskId parentTaskId) {
        return this.setTargetParentTaskId(parentTaskId);
    }

    public TimeValue getTimeout() {
        return this.timeout;
    }

    public final Request setTimeout(TimeValue timeout) {
        this.timeout = timeout;
        return (Request)this;
    }

    public final Request setTimeout(String timeout) {
        this.timeout = TimeValue.parseTimeValue(timeout, null, this.getClass().getSimpleName() + ".timeout");
        return (Request)this;
    }

    public boolean match(Task task) {
        if (!CollectionUtils.isEmpty(this.getActions()) && !Regex.simpleMatch(this.getActions(), task.getAction())) {
            return false;
        }
        if (this.getTargetTaskId().isSet() && this.getTargetTaskId().getId() != task.getId()) {
            return false;
        }
        return !this.targetParentTaskId.isSet() || this.targetParentTaskId.equals(task.getParentTaskId());
    }
}

