/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.admin.cluster.node.tasks.cancel.CancelTasksRequest;
import org.elasticsearch.action.search.CanMatchNodeRequest;
import org.elasticsearch.action.search.CanMatchNodeResponse;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchActionListener;
import org.elasticsearch.action.search.SearchShardTask;
import org.elasticsearch.action.search.SearchTask;
import org.elasticsearch.action.search.SearchTransportAPMMetrics;
import org.elasticsearch.action.search.TransportMultiSearchAction;
import org.elasticsearch.action.support.ChannelActionListener;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.dfs.DfsSearchResult;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.fetch.QueryFetchSearchResult;
import org.elasticsearch.search.fetch.ScrollQueryFetchSearchResult;
import org.elasticsearch.search.fetch.ShardFetchRequest;
import org.elasticsearch.search.fetch.ShardFetchSearchRequest;
import org.elasticsearch.search.internal.InternalScrollSearchRequest;
import org.elasticsearch.search.internal.ShardSearchContextId;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.search.query.QuerySearchRequest;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.search.query.ScrollQuerySearchResult;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.telemetry.metric.LongHistogram;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportActionProxy;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;

public class SearchTransportService {
    public static final String FREE_CONTEXT_SCROLL_ACTION_NAME = "indices:data/read/search[free_context/scroll]";
    public static final String FREE_CONTEXT_ACTION_NAME = "indices:data/read/search[free_context]";
    public static final String CLEAR_SCROLL_CONTEXTS_ACTION_NAME = "indices:data/read/search[clear_scroll_contexts]";
    public static final String DFS_ACTION_NAME = "indices:data/read/search[phase/dfs]";
    public static final String QUERY_ACTION_NAME = "indices:data/read/search[phase/query]";
    public static final String QUERY_ID_ACTION_NAME = "indices:data/read/search[phase/query/id]";
    public static final String QUERY_SCROLL_ACTION_NAME = "indices:data/read/search[phase/query/scroll]";
    public static final String QUERY_FETCH_SCROLL_ACTION_NAME = "indices:data/read/search[phase/query+fetch/scroll]";
    public static final String FETCH_ID_SCROLL_ACTION_NAME = "indices:data/read/search[phase/fetch/id/scroll]";
    public static final String FETCH_ID_ACTION_NAME = "indices:data/read/search[phase/fetch/id]";
    public static final String QUERY_CAN_MATCH_NODE_NAME = "indices:data/read/search[can_match][n]";
    private final TransportService transportService;
    private final NodeClient client;
    private final BiFunction<Transport.Connection, SearchActionListener<? super SearchPhaseResult>, ActionListener<? super SearchPhaseResult>> responseWrapper;
    private final Map<String, Long> clientConnections = ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency();

    public SearchTransportService(TransportService transportService, NodeClient client, BiFunction<Transport.Connection, SearchActionListener<? super SearchPhaseResult>, ActionListener<? super SearchPhaseResult>> responseWrapper) {
        this.transportService = transportService;
        this.client = client;
        this.responseWrapper = responseWrapper;
    }

    public void sendFreeContext(Transport.Connection connection, ShardSearchContextId contextId, OriginalIndices originalIndices) {
        this.transportService.sendRequest(connection, FREE_CONTEXT_ACTION_NAME, (TransportRequest)new SearchFreeContextRequest(originalIndices, contextId), TransportRequestOptions.EMPTY, new ActionListenerResponseHandler<SearchFreeContextResponse>(ActionListener.noop(), SearchFreeContextResponse::new, TransportResponseHandler.TRANSPORT_WORKER));
    }

    public void sendFreeContext(Transport.Connection connection, ShardSearchContextId contextId, ActionListener<SearchFreeContextResponse> listener) {
        this.transportService.sendRequest(connection, FREE_CONTEXT_SCROLL_ACTION_NAME, (TransportRequest)new ScrollFreeContextRequest(contextId), TransportRequestOptions.EMPTY, new ActionListenerResponseHandler<SearchFreeContextResponse>(listener, SearchFreeContextResponse::new, TransportResponseHandler.TRANSPORT_WORKER));
    }

    public void sendCanMatch(Transport.Connection connection, CanMatchNodeRequest request, SearchTask task, ActionListener<CanMatchNodeResponse> listener) {
        this.transportService.sendChildRequest(connection, QUERY_CAN_MATCH_NODE_NAME, (TransportRequest)request, (Task)task, TransportRequestOptions.EMPTY, new ActionListenerResponseHandler<CanMatchNodeResponse>(listener, CanMatchNodeResponse::new, TransportResponseHandler.TRANSPORT_WORKER));
    }

    public void sendClearAllScrollContexts(Transport.Connection connection, ActionListener<TransportResponse> listener) {
        this.transportService.sendRequest(connection, CLEAR_SCROLL_CONTEXTS_ACTION_NAME, (TransportRequest)TransportRequest.Empty.INSTANCE, TransportRequestOptions.EMPTY, new ActionListenerResponseHandler<TransportResponse.Empty>(listener, in -> TransportResponse.Empty.INSTANCE, TransportResponseHandler.TRANSPORT_WORKER));
    }

    public void sendExecuteDfs(Transport.Connection connection, ShardSearchRequest request, SearchTask task, SearchActionListener<DfsSearchResult> listener) {
        this.transportService.sendChildRequest(connection, DFS_ACTION_NAME, request, task, new ConnectionCountingHandler<DfsSearchResult>(listener, DfsSearchResult::new, connection));
    }

    public void sendExecuteQuery(Transport.Connection connection, ShardSearchRequest request, SearchTask task, SearchActionListener<? super SearchPhaseResult> listener) {
        boolean fetchDocuments = request.numberOfShards() == 1 && (request.source() == null || request.source().rankBuilder() == null);
        Writeable.Reader<SearchPhaseResult> reader = fetchDocuments ? QueryFetchSearchResult::new : in -> new QuerySearchResult(in, true);
        ActionListener<? super SearchPhaseResult> handler = this.responseWrapper.apply(connection, listener);
        this.transportService.sendChildRequest(connection, QUERY_ACTION_NAME, request, task, new ConnectionCountingHandler<SearchPhaseResult>(handler, reader, connection));
    }

    public void sendExecuteQuery(Transport.Connection connection, QuerySearchRequest request, SearchTask task, SearchActionListener<QuerySearchResult> listener) {
        this.transportService.sendChildRequest(connection, QUERY_ID_ACTION_NAME, request, task, new ConnectionCountingHandler<QuerySearchResult>(listener, QuerySearchResult::new, connection));
    }

    public void sendExecuteScrollQuery(Transport.Connection connection, InternalScrollSearchRequest request, SearchTask task, SearchActionListener<ScrollQuerySearchResult> listener) {
        this.transportService.sendChildRequest(connection, QUERY_SCROLL_ACTION_NAME, request, task, new ConnectionCountingHandler<ScrollQuerySearchResult>(listener, ScrollQuerySearchResult::new, connection));
    }

    public void sendExecuteScrollFetch(Transport.Connection connection, InternalScrollSearchRequest request, SearchTask task, SearchActionListener<ScrollQueryFetchSearchResult> listener) {
        this.transportService.sendChildRequest(connection, QUERY_FETCH_SCROLL_ACTION_NAME, request, task, new ConnectionCountingHandler<ScrollQueryFetchSearchResult>(listener, ScrollQueryFetchSearchResult::new, connection));
    }

    public void sendExecuteFetch(Transport.Connection connection, ShardFetchSearchRequest request, SearchTask task, SearchActionListener<FetchSearchResult> listener) {
        this.sendExecuteFetch(connection, FETCH_ID_ACTION_NAME, request, task, listener);
    }

    public void sendExecuteFetchScroll(Transport.Connection connection, ShardFetchRequest request, SearchTask task, SearchActionListener<FetchSearchResult> listener) {
        this.sendExecuteFetch(connection, FETCH_ID_SCROLL_ACTION_NAME, request, task, listener);
    }

    private void sendExecuteFetch(Transport.Connection connection, String action, ShardFetchRequest request, SearchTask task, SearchActionListener<FetchSearchResult> listener) {
        this.transportService.sendChildRequest(connection, action, request, task, new ConnectionCountingHandler<FetchSearchResult>(listener, FetchSearchResult::new, connection));
    }

    void sendExecuteMultiSearch(MultiSearchRequest request, SearchTask task, ActionListener<MultiSearchResponse> listener) {
        Transport.Connection connection = this.transportService.getConnection(this.transportService.getLocalNode());
        this.transportService.sendChildRequest(connection, TransportMultiSearchAction.TYPE.name(), request, task, new ConnectionCountingHandler<MultiSearchResponse>(listener, MultiSearchResponse::new, connection));
    }

    public RemoteClusterService getRemoteClusterService() {
        return this.transportService.getRemoteClusterService();
    }

    public Map<String, Long> getPendingSearchRequests() {
        return new HashMap<String, Long>(this.clientConnections);
    }

    public static void registerRequestHandler(TransportService transportService, SearchService searchService, SearchTransportAPMMetrics searchTransportMetrics) {
        TransportRequestHandler<ScrollFreeContextRequest> freeContextHandler = (request, channel, task) -> {
            boolean freed = searchService.freeReaderContext(request.id());
            channel.sendResponse(new SearchFreeContextResponse(freed));
        };
        transportService.registerRequestHandler(FREE_CONTEXT_SCROLL_ACTION_NAME, EsExecutors.DIRECT_EXECUTOR_SERVICE, ScrollFreeContextRequest::new, SearchTransportService.instrumentedHandler("scroll/shard_release_context", transportService, searchTransportMetrics, freeContextHandler));
        TransportActionProxy.registerProxyAction(transportService, FREE_CONTEXT_SCROLL_ACTION_NAME, false, SearchFreeContextResponse::new);
        transportService.registerRequestHandler(FREE_CONTEXT_ACTION_NAME, EsExecutors.DIRECT_EXECUTOR_SERVICE, SearchFreeContextRequest::new, SearchTransportService.instrumentedHandler("shard_release_context", transportService, searchTransportMetrics, freeContextHandler));
        TransportActionProxy.registerProxyAction(transportService, FREE_CONTEXT_ACTION_NAME, false, SearchFreeContextResponse::new);
        transportService.registerRequestHandler(CLEAR_SCROLL_CONTEXTS_ACTION_NAME, EsExecutors.DIRECT_EXECUTOR_SERVICE, TransportRequest.Empty::new, SearchTransportService.instrumentedHandler("scroll/shard_release_contexts", transportService, searchTransportMetrics, (request, channel, task) -> {
            searchService.freeAllScrollContexts();
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }));
        TransportActionProxy.registerProxyAction(transportService, CLEAR_SCROLL_CONTEXTS_ACTION_NAME, false, in -> TransportResponse.Empty.INSTANCE);
        transportService.registerRequestHandler(DFS_ACTION_NAME, EsExecutors.DIRECT_EXECUTOR_SERVICE, ShardSearchRequest::new, SearchTransportService.instrumentedHandler("dfs_query_then_fetch/shard_dfs_phase", transportService, searchTransportMetrics, (request, channel, task) -> searchService.executeDfsPhase((ShardSearchRequest)request, (SearchShardTask)task, (ActionListener<SearchPhaseResult>)new ChannelActionListener<SearchPhaseResult>(channel))));
        TransportActionProxy.registerProxyAction(transportService, DFS_ACTION_NAME, true, DfsSearchResult::new);
        transportService.registerRequestHandler(QUERY_ACTION_NAME, EsExecutors.DIRECT_EXECUTOR_SERVICE, ShardSearchRequest::new, SearchTransportService.instrumentedHandler("query_then_fetch/shard_query_phase", transportService, searchTransportMetrics, (request, channel, task) -> searchService.executeQueryPhase((ShardSearchRequest)request, (SearchShardTask)task, (ActionListener<SearchPhaseResult>)new ChannelActionListener<SearchPhaseResult>(channel))));
        TransportActionProxy.registerProxyActionWithDynamicResponseType(transportService, QUERY_ACTION_NAME, true, request -> ((ShardSearchRequest)request).numberOfShards() == 1 ? QueryFetchSearchResult::new : QuerySearchResult::new);
        transportService.registerRequestHandler(QUERY_ID_ACTION_NAME, EsExecutors.DIRECT_EXECUTOR_SERVICE, QuerySearchRequest::new, SearchTransportService.instrumentedHandler("dfs_query_then_fetch/shard_query_phase", transportService, searchTransportMetrics, (request, channel, task) -> searchService.executeQueryPhase((QuerySearchRequest)request, (SearchShardTask)task, (ActionListener<QuerySearchResult>)new ChannelActionListener<QuerySearchResult>(channel))));
        TransportActionProxy.registerProxyAction(transportService, QUERY_ID_ACTION_NAME, true, QuerySearchResult::new);
        transportService.registerRequestHandler(QUERY_SCROLL_ACTION_NAME, EsExecutors.DIRECT_EXECUTOR_SERVICE, InternalScrollSearchRequest::new, SearchTransportService.instrumentedHandler("scroll/shard_query_phase", transportService, searchTransportMetrics, (request, channel, task) -> searchService.executeQueryPhase((InternalScrollSearchRequest)request, (SearchShardTask)task, (ActionListener<ScrollQuerySearchResult>)new ChannelActionListener<ScrollQuerySearchResult>(channel))));
        TransportActionProxy.registerProxyAction(transportService, QUERY_SCROLL_ACTION_NAME, true, ScrollQuerySearchResult::new);
        transportService.registerRequestHandler(QUERY_FETCH_SCROLL_ACTION_NAME, EsExecutors.DIRECT_EXECUTOR_SERVICE, InternalScrollSearchRequest::new, SearchTransportService.instrumentedHandler("scroll/shard_query_and_fetch_phase", transportService, searchTransportMetrics, (request, channel, task) -> searchService.executeFetchPhase((InternalScrollSearchRequest)request, (SearchShardTask)task, (ActionListener<ScrollQueryFetchSearchResult>)new ChannelActionListener<ScrollQueryFetchSearchResult>(channel))));
        TransportActionProxy.registerProxyAction(transportService, QUERY_FETCH_SCROLL_ACTION_NAME, true, ScrollQueryFetchSearchResult::new);
        TransportRequestHandler<ShardFetchRequest> shardFetchRequestHandler = (request, channel, task) -> searchService.executeFetchPhase((ShardFetchRequest)request, (SearchShardTask)task, (ActionListener<FetchSearchResult>)new ChannelActionListener<FetchSearchResult>(channel));
        transportService.registerRequestHandler(FETCH_ID_SCROLL_ACTION_NAME, EsExecutors.DIRECT_EXECUTOR_SERVICE, ShardFetchRequest::new, SearchTransportService.instrumentedHandler("scroll/shard_fetch_phase", transportService, searchTransportMetrics, shardFetchRequestHandler));
        TransportActionProxy.registerProxyAction(transportService, FETCH_ID_SCROLL_ACTION_NAME, true, FetchSearchResult::new);
        transportService.registerRequestHandler(FETCH_ID_ACTION_NAME, EsExecutors.DIRECT_EXECUTOR_SERVICE, true, true, ShardFetchSearchRequest::new, SearchTransportService.instrumentedHandler("shard_fetch_phase", transportService, searchTransportMetrics, shardFetchRequestHandler));
        TransportActionProxy.registerProxyAction(transportService, FETCH_ID_ACTION_NAME, true, FetchSearchResult::new);
        transportService.registerRequestHandler(QUERY_CAN_MATCH_NODE_NAME, transportService.getThreadPool().executor("search_coordination"), CanMatchNodeRequest::new, SearchTransportService.instrumentedHandler("shards_can_match", transportService, searchTransportMetrics, (request, channel, task) -> searchService.canMatch((CanMatchNodeRequest)request, (ActionListener<CanMatchNodeResponse>)new ChannelActionListener<CanMatchNodeResponse>(channel))));
        TransportActionProxy.registerProxyAction(transportService, QUERY_CAN_MATCH_NODE_NAME, true, CanMatchNodeResponse::new);
    }

    private static <Request extends TransportRequest> TransportRequestHandler<Request> instrumentedHandler(String actionQualifier, TransportService transportService, SearchTransportAPMMetrics searchTransportMetrics, TransportRequestHandler<Request> transportRequestHandler) {
        ThreadPool threadPool = transportService.getThreadPool();
        LongHistogram latencies = searchTransportMetrics.getActionLatencies();
        Map<String, String> attributes = Map.of("action", actionQualifier);
        return (request, channel, task) -> {
            long startTime = threadPool.relativeTimeInMillis();
            try {
                transportRequestHandler.messageReceived(request, channel, task);
            }
            finally {
                long elapsedTime = threadPool.relativeTimeInMillis() - startTime;
                latencies.record(elapsedTime, attributes);
            }
        };
    }

    public Transport.Connection getConnection(@Nullable String clusterAlias, DiscoveryNode node) {
        if (clusterAlias == null) {
            return this.transportService.getConnection(node);
        }
        return this.transportService.getRemoteClusterService().getConnection(node, clusterAlias);
    }

    public void cancelSearchTask(SearchTask task, String reason) {
        CancelTasksRequest req = ((CancelTasksRequest)new CancelTasksRequest().setTargetTaskId(new TaskId(this.client.getLocalNodeId(), task.getId()))).setReason("Fatal failure during search: " + reason);
        new OriginSettingClient(this.client, "tasks").admin().cluster().cancelTasks(req, ActionListener.noop());
    }

    static class SearchFreeContextRequest
    extends ScrollFreeContextRequest
    implements IndicesRequest {
        private final OriginalIndices originalIndices;

        SearchFreeContextRequest(OriginalIndices originalIndices, ShardSearchContextId id) {
            super(id);
            this.originalIndices = originalIndices;
        }

        SearchFreeContextRequest(StreamInput in) throws IOException {
            super(in);
            this.originalIndices = OriginalIndices.readOriginalIndices(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            OriginalIndices.writeOriginalIndices(this.originalIndices, out);
        }

        @Override
        public String[] indices() {
            if (this.originalIndices == null) {
                return null;
            }
            return this.originalIndices.indices();
        }

        @Override
        public IndicesOptions indicesOptions() {
            if (this.originalIndices == null) {
                return null;
            }
            return this.originalIndices.indicesOptions();
        }
    }

    static class ScrollFreeContextRequest
    extends TransportRequest {
        private final ShardSearchContextId contextId;

        ScrollFreeContextRequest(ShardSearchContextId contextId) {
            this.contextId = Objects.requireNonNull(contextId);
        }

        ScrollFreeContextRequest(StreamInput in) throws IOException {
            super(in);
            this.contextId = new ShardSearchContextId(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.contextId.writeTo(out);
        }

        public ShardSearchContextId id() {
            return this.contextId;
        }
    }

    private final class ConnectionCountingHandler<Response extends TransportResponse>
    extends ActionListenerResponseHandler<Response> {
        private final String nodeId;

        ConnectionCountingHandler(ActionListener<? super Response> listener, Writeable.Reader<Response> responseReader, Transport.Connection connection) {
            super(listener, responseReader, TransportResponseHandler.TRANSPORT_WORKER);
            this.nodeId = connection.getNode().getId();
            SearchTransportService.this.clientConnections.compute(this.nodeId, (id, conns) -> conns == null ? 1L : conns + 1L);
        }

        @Override
        public void handleResponse(Response response) {
            super.handleResponse(response);
            this.decConnectionCount();
        }

        @Override
        public void handleException(TransportException e) {
            super.handleException(e);
            this.decConnectionCount();
        }

        private void decConnectionCount() {
            assert (this.assertNodePresent());
            SearchTransportService.this.clientConnections.computeIfPresent(this.nodeId, (id, conns) -> conns == 1L ? null : Long.valueOf(conns - 1L));
        }

        private boolean assertNodePresent() {
            Long conns = SearchTransportService.this.clientConnections.get(this.nodeId);
            assert (conns != null) : "number of connections for " + this.nodeId + " is null, but should be an integer";
            assert (conns >= 1L) : "number of connections for " + this.nodeId + " should be >= 1 but was " + conns;
            return true;
        }
    }

    public static class SearchFreeContextResponse
    extends TransportResponse {
        private final boolean freed;

        SearchFreeContextResponse(StreamInput in) throws IOException {
            this.freed = in.readBoolean();
        }

        SearchFreeContextResponse(boolean freed) {
            this.freed = freed;
        }

        public boolean isFreed() {
            return this.freed;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeBoolean(this.freed);
        }
    }
}

