/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public final class OpenPointInTimeResponse
extends ActionResponse
implements ToXContentObject {
    private final String pointInTimeId;

    public OpenPointInTimeResponse(String pointInTimeId) {
        this.pointInTimeId = Objects.requireNonNull(pointInTimeId, "Point in time parameter must be not null");
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.pointInTimeId);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("id", this.pointInTimeId);
        builder.endObject();
        return builder;
    }

    public String getPointInTimeId() {
        return this.pointInTimeId;
    }
}

