/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.ingest;

import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.script.Metadata;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

final class WriteableIngestDocument
implements Writeable,
ToXContentFragment {
    static final String SOURCE_FIELD = "_source";
    static final String INGEST_FIELD = "_ingest";
    static final String DOC_FIELD = "doc";
    private final IngestDocument ingestDocument;
    public static final ConstructingObjectParser<WriteableIngestDocument, Void> INGEST_DOC_PARSER = new ConstructingObjectParser("ingest_document", true, a -> {
        Map source = (Map)a[5];
        Map<String, Object> sourceAndMetadata = Maps.newHashMapWithExpectedSize(5 + source.size());
        sourceAndMetadata.putAll(source);
        sourceAndMetadata.put(IngestDocument.Metadata.INDEX.getFieldName(), a[0]);
        sourceAndMetadata.put(IngestDocument.Metadata.ID.getFieldName(), a[1]);
        if (a[2] != null) {
            sourceAndMetadata.put(IngestDocument.Metadata.ROUTING.getFieldName(), a[2]);
        }
        if (a[3] != null) {
            sourceAndMetadata.put(IngestDocument.Metadata.VERSION.getFieldName(), a[3]);
        }
        if (a[4] != null) {
            sourceAndMetadata.put(IngestDocument.Metadata.VERSION_TYPE.getFieldName(), a[4]);
        }
        Map ingestMetadata = (Map)a[6];
        return new WriteableIngestDocument(sourceAndMetadata, ingestMetadata);
    });
    public static final ConstructingObjectParser<WriteableIngestDocument, Void> PARSER;

    WriteableIngestDocument(IngestDocument ingestDocument) {
        assert (ingestDocument != null);
        this.ingestDocument = new IngestDocument(ingestDocument);
    }

    private WriteableIngestDocument(Map<String, Object> sourceAndMetadata, Map<String, Object> ingestMetadata) {
        this.ingestDocument = new IngestDocument(sourceAndMetadata, ingestMetadata);
    }

    WriteableIngestDocument(StreamInput in) throws IOException {
        this(in.readGenericMap(), in.readGenericMap());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeGenericMap(this.ingestDocument.getSourceAndMetadata());
        out.writeGenericMap(this.ingestDocument.getIngestMetadata());
    }

    IngestDocument getIngestDocument() {
        return this.ingestDocument;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(DOC_FIELD);
        Metadata metadata = this.ingestDocument.getMetadata();
        for (String key : metadata.keySet()) {
            Object value = metadata.get(key);
            if (value == null) continue;
            builder.field(key, value.toString());
        }
        if (builder.getRestApiVersion() == RestApiVersion.V_7) {
            builder.field("_type", "_doc");
        }
        builder.field(SOURCE_FIELD, this.ingestDocument.getSource());
        builder.field(INGEST_FIELD, this.ingestDocument.getIngestMetadata());
        builder.endObject();
        return builder;
    }

    public static WriteableIngestDocument fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    public String toString() {
        return this.ingestDocument.toString();
    }

    static {
        INGEST_DOC_PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(IngestDocument.Metadata.INDEX.getFieldName(), new String[0]));
        INGEST_DOC_PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(IngestDocument.Metadata.ID.getFieldName(), new String[0]));
        INGEST_DOC_PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField(IngestDocument.Metadata.ROUTING.getFieldName(), new String[0]));
        INGEST_DOC_PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), new ParseField(IngestDocument.Metadata.VERSION.getFieldName(), new String[0]));
        INGEST_DOC_PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField(IngestDocument.Metadata.VERSION_TYPE.getFieldName(), new String[0]));
        INGEST_DOC_PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> p.map(), new ParseField(SOURCE_FIELD, new String[0]));
        INGEST_DOC_PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> {
            Map<String, Object> ingestMap = p.map();
            ingestMap.computeIfPresent("timestamp", (k, o) -> ZonedDateTime.parse((String)o));
            return ingestMap;
        }, new ParseField(INGEST_FIELD, new String[0]));
        PARSER = new ConstructingObjectParser("writeable_ingest_document", true, a -> (WriteableIngestDocument)a[0]);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), INGEST_DOC_PARSER, new ParseField(DOC_FIELD, new String[0]));
    }
}

