/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.io.IOException;
import java.util.Objects;
import java.util.function.Supplier;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.json.JsonXContent;

public class FailureStoreDocumentConverter {
    public IndexRequest transformFailedRequest(IndexRequest source, Exception exception, String targetIndexName) throws IOException {
        return this.transformFailedRequest(source, exception, targetIndexName, System::currentTimeMillis);
    }

    public IndexRequest transformFailedRequest(IndexRequest source, Exception exception, String targetIndexName, Supplier<Long> timeSupplier) throws IOException {
        return ((IndexRequest)new IndexRequest().index(targetIndexName)).source(FailureStoreDocumentConverter.createSource(source, exception, targetIndexName, timeSupplier)).opType(DocWriteRequest.OpType.CREATE).setWriteToFailureStore(true);
    }

    private static XContentBuilder createSource(IndexRequest source, Exception exception, String targetIndexName, Supplier<Long> timeSupplier) throws IOException {
        Objects.requireNonNull(source, "source must not be null");
        Objects.requireNonNull(exception, "exception must not be null");
        Objects.requireNonNull(targetIndexName, "targetIndexName must not be null");
        Objects.requireNonNull(timeSupplier, "timeSupplier must not be null");
        Throwable unwrapped = ExceptionsHelper.unwrapCause(exception);
        XContentBuilder builder = JsonXContent.contentBuilder();
        builder.startObject();
        builder.timeField("@timestamp", timeSupplier.get());
        builder.startObject("document");
        if (source.id() != null) {
            builder.field("id", source.id());
        }
        if (source.routing() != null) {
            builder.field("routing", source.routing());
        }
        builder.field("index", source.index());
        builder.startObject("source");
        builder.mapContents(source.sourceAsMap());
        builder.endObject();
        builder.endObject();
        builder.startObject("error");
        builder.field("type", ElasticsearchException.getExceptionName(unwrapped));
        builder.field("message", unwrapped.getMessage());
        builder.field("stack_trace", ExceptionsHelper.stackTrace(unwrapped));
        builder.endObject();
        builder.endObject();
        return builder;
    }
}

