/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.shrink;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.shrink.ResizeType;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class ResizeRequest
extends AcknowledgedRequest<ResizeRequest>
implements IndicesRequest,
ToXContentObject {
    public static final ObjectParser<ResizeRequest, Void> PARSER = new ObjectParser("resize_request");
    private static final ParseField MAX_PRIMARY_SHARD_SIZE = new ParseField("max_primary_shard_size", new String[0]);
    private CreateIndexRequest targetIndexRequest;
    private String sourceIndex;
    private ResizeType type = ResizeType.SHRINK;
    private Boolean copySettings = true;
    private ByteSizeValue maxPrimaryShardSize;

    public ResizeRequest(StreamInput in) throws IOException {
        super(in);
        this.targetIndexRequest = new CreateIndexRequest(in);
        this.sourceIndex = in.readString();
        this.type = in.readEnum(ResizeType.class);
        this.copySettings = in.readOptionalBoolean();
        if (in.readBoolean()) {
            this.maxPrimaryShardSize = ByteSizeValue.readFrom(in);
        }
    }

    ResizeRequest() {
    }

    public ResizeRequest(String targetIndex, String sourceIndex) {
        this.targetIndexRequest = new CreateIndexRequest(targetIndex);
        this.sourceIndex = sourceIndex;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException;
        ActionRequestValidationException actionRequestValidationException = validationException = this.targetIndexRequest == null ? null : this.targetIndexRequest.validate();
        if (this.sourceIndex == null) {
            validationException = ValidateActions.addValidationError("source index is missing", validationException);
        }
        if (this.targetIndexRequest == null) {
            validationException = ValidateActions.addValidationError("target index request is missing", validationException);
        }
        if (!this.targetIndexRequest.settings().getByPrefix("index.sort.").isEmpty()) {
            validationException = ValidateActions.addValidationError("can't override index sort when resizing an index", validationException);
        }
        if (this.type == ResizeType.SPLIT && !IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.exists(this.targetIndexRequest.settings())) {
            validationException = ValidateActions.addValidationError("index.number_of_shards is required for split operations", validationException);
        }
        if (this.maxPrimaryShardSize != null && this.maxPrimaryShardSize.getBytes() <= 0L) {
            validationException = ValidateActions.addValidationError("max_primary_shard_size must be greater than 0", validationException);
        }
        assert (this.copySettings == null || this.copySettings.booleanValue());
        return validationException;
    }

    public void setSourceIndex(String index) {
        this.sourceIndex = index;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.targetIndexRequest.writeTo(out);
        out.writeString(this.sourceIndex);
        out.writeEnum(this.type);
        out.writeOptionalBoolean(this.copySettings);
        out.writeOptionalWriteable(this.maxPrimaryShardSize);
    }

    @Override
    public String[] indices() {
        return new String[]{this.sourceIndex};
    }

    @Override
    public IndicesOptions indicesOptions() {
        return IndicesOptions.lenientExpandOpen();
    }

    public void setTargetIndex(CreateIndexRequest targetIndexRequest) {
        this.targetIndexRequest = Objects.requireNonNull(targetIndexRequest, "target index request must not be null");
    }

    public CreateIndexRequest getTargetIndexRequest() {
        return this.targetIndexRequest;
    }

    public String getSourceIndex() {
        return this.sourceIndex;
    }

    public void setWaitForActiveShards(ActiveShardCount waitForActiveShards) {
        this.getTargetIndexRequest().waitForActiveShards(waitForActiveShards);
    }

    public void setWaitForActiveShards(int waitForActiveShards) {
        this.setWaitForActiveShards(ActiveShardCount.from(waitForActiveShards));
    }

    public void setResizeType(ResizeType type) {
        this.type = Objects.requireNonNull(type);
    }

    public ResizeType getResizeType() {
        return this.type;
    }

    public void setCopySettings(Boolean copySettings) {
        if (copySettings != null && !copySettings.booleanValue()) {
            throw new IllegalArgumentException("[copySettings] can not be explicitly set to [false]");
        }
        this.copySettings = copySettings;
    }

    public Boolean getCopySettings() {
        return this.copySettings;
    }

    public void setMaxPrimaryShardSize(ByteSizeValue maxPrimaryShardSize) {
        this.maxPrimaryShardSize = maxPrimaryShardSize;
    }

    public ByteSizeValue getMaxPrimaryShardSize() {
        return this.maxPrimaryShardSize;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject(CreateIndexRequest.SETTINGS.getPreferredName());
        this.targetIndexRequest.settings().toXContent(builder, params);
        builder.endObject();
        builder.startObject(CreateIndexRequest.ALIASES.getPreferredName());
        for (Alias alias : this.targetIndexRequest.aliases()) {
            alias.toXContent(builder, params);
        }
        builder.endObject();
        if (this.maxPrimaryShardSize != null) {
            builder.field(MAX_PRIMARY_SHARD_SIZE.getPreferredName(), this.maxPrimaryShardSize);
        }
        builder.endObject();
        return builder;
    }

    public void fromXContent(XContentParser parser) throws IOException {
        PARSER.parse(parser, this, null);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ResizeRequest that = (ResizeRequest)obj;
        return Objects.equals(this.targetIndexRequest, that.targetIndexRequest) && Objects.equals(this.sourceIndex, that.sourceIndex) && Objects.equals((Object)this.type, (Object)that.type) && Objects.equals(this.copySettings, that.copySettings) && Objects.equals(this.maxPrimaryShardSize, that.maxPrimaryShardSize);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.targetIndexRequest, this.sourceIndex, this.type, this.copySettings, this.maxPrimaryShardSize});
    }

    static {
        PARSER.declareField((parser, request, context) -> request.getTargetIndexRequest().settings(parser.map()), new ParseField("settings", new String[0]), ObjectParser.ValueType.OBJECT);
        PARSER.declareField((parser, request, context) -> request.getTargetIndexRequest().aliases(parser.map()), new ParseField("aliases", new String[0]), ObjectParser.ValueType.OBJECT);
        PARSER.declareField(ResizeRequest::setMaxPrimaryShardSize, (p, c) -> ByteSizeValue.parseBytesSizeValue(p.text(), MAX_PRIMARY_SHARD_SIZE.getPreferredName()), MAX_PRIMARY_SHARD_SIZE, ObjectParser.ValueType.STRING);
    }
}

