/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.close;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.action.support.master.ShardsAcknowledgedResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.Index;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public class CloseIndexResponse
extends ShardsAcknowledgedResponse {
    public static final CloseIndexResponse EMPTY = new CloseIndexResponse(true, false, List.of());
    private final List<IndexResult> indices;

    CloseIndexResponse(StreamInput in) throws IOException {
        super(in, true);
        this.indices = in.readCollectionAsImmutableList(IndexResult::new);
    }

    public CloseIndexResponse(boolean acknowledged, boolean shardsAcknowledged, List<IndexResult> indices) {
        super(acknowledged, shardsAcknowledged);
        this.indices = List.copyOf(indices);
    }

    public List<IndexResult> getIndices() {
        return this.indices;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.writeShardsAcknowledged(out);
        out.writeCollection(this.indices);
    }

    @Override
    protected void addCustomFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        super.addCustomFields(builder, params);
        builder.startObject("indices");
        for (IndexResult index : this.indices) {
            index.toXContent(builder, params);
        }
        builder.endObject();
    }

    public String toString() {
        return Strings.toString(this);
    }

    public static class IndexResult
    implements Writeable,
    ToXContentFragment {
        private final Index index;
        @Nullable
        private final Exception exception;
        @Nullable
        private final ShardResult[] shards;

        public IndexResult(Index index) {
            this(index, null, null);
        }

        public IndexResult(Index index, Exception failure) {
            this(index, Objects.requireNonNull(failure), null);
        }

        public IndexResult(Index index, ShardResult[] shards) {
            this(index, null, Objects.requireNonNull(shards));
        }

        private IndexResult(Index index, @Nullable Exception exception, @Nullable ShardResult[] shards) {
            this.index = Objects.requireNonNull(index);
            this.exception = exception;
            this.shards = shards;
        }

        IndexResult(StreamInput in) throws IOException {
            this.index = new Index(in);
            this.exception = in.readException();
            this.shards = in.readOptionalArray(ShardResult::new, ShardResult[]::new);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.index.writeTo(out);
            out.writeException(this.exception);
            out.writeOptionalArray(this.shards);
        }

        public Index getIndex() {
            return this.index;
        }

        public Exception getException() {
            return this.exception;
        }

        public ShardResult[] getShards() {
            return this.shards;
        }

        public boolean hasFailures() {
            if (this.exception != null) {
                return true;
            }
            if (this.shards != null) {
                for (ShardResult shard : this.shards) {
                    if (!shard.hasFailures()) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(this.index.getName());
            if (this.hasFailures()) {
                builder.field("closed", false);
                if (this.exception != null) {
                    builder.startObject("exception");
                    ElasticsearchException.generateFailureXContent(builder, params, this.exception, true);
                    builder.endObject();
                } else {
                    builder.startObject("failedShards");
                    for (ShardResult shard : this.shards) {
                        if (!shard.hasFailures()) continue;
                        shard.toXContent(builder, params);
                    }
                    builder.endObject();
                }
            } else {
                builder.field("closed", true);
            }
            return builder.endObject();
        }

        public String toString() {
            return Strings.toString(this);
        }
    }

    public static class ShardResult
    implements Writeable,
    ToXContentFragment {
        private final int id;
        private final Failure[] failures;

        public ShardResult(int id, Failure[] failures) {
            this.id = id;
            this.failures = failures;
        }

        ShardResult(StreamInput in) throws IOException {
            this.id = in.readVInt();
            this.failures = in.readOptionalArray(Failure::readFailure, Failure[]::new);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.id);
            out.writeOptionalArray(this.failures);
        }

        public boolean hasFailures() {
            return !CollectionUtils.isEmpty(this.failures);
        }

        public int getId() {
            return this.id;
        }

        public Failure[] getFailures() {
            return this.failures;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(String.valueOf(this.id));
            builder.startArray("failures");
            if (this.failures != null) {
                for (Failure failure : this.failures) {
                    failure.toXContent(builder, params);
                }
            }
            builder.endArray();
            return builder.endObject();
        }

        public String toString() {
            return Strings.toString(this);
        }

        public static class Failure
        extends DefaultShardOperationFailedException {
            @Nullable
            private String nodeId;

            private Failure(StreamInput in) throws IOException {
                super(in);
                this.nodeId = in.readOptionalString();
            }

            public Failure(String index, int shardId, Throwable reason) {
                this(index, shardId, reason, null);
            }

            public Failure(String index, int shardId, Throwable reason, String nodeId) {
                super(index, shardId, reason);
                this.nodeId = nodeId;
            }

            public String getNodeId() {
                return this.nodeId;
            }

            @Override
            public void writeTo(StreamOutput out) throws IOException {
                super.writeTo(out);
                out.writeOptionalString(this.nodeId);
            }

            @Override
            public XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                if (this.nodeId != null) {
                    builder.field("node", this.nodeId);
                }
                return super.innerToXContent(builder, params);
            }

            @Override
            public String toString() {
                return Strings.toString(this);
            }

            static Failure readFailure(StreamInput in) throws IOException {
                return new Failure(in);
            }
        }
    }
}

