/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.shutdown;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.master.MasterNodeReadRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;

public class PrevalidateNodeRemovalRequest
extends MasterNodeReadRequest<PrevalidateNodeRemovalRequest> {
    public static final String VALIDATION_ERROR_MSG_ONLY_ONE_QUERY_PARAM = "request must contain only one of the parameters 'names', 'ids', or 'external_ids'";
    public static final String VALIDATION_ERROR_MSG_NO_QUERY_PARAM = "request must contain one of the parameters 'names', 'ids', or 'external_ids'";
    private final String[] names;
    private final String[] ids;
    private final String[] externalIds;
    private TimeValue timeout = TimeValue.timeValueSeconds(30L);

    private PrevalidateNodeRemovalRequest(Builder builder) {
        this.names = builder.names;
        this.ids = builder.ids;
        this.externalIds = builder.externalIds;
    }

    public PrevalidateNodeRemovalRequest(StreamInput in) throws IOException {
        super(in);
        this.names = in.readStringArray();
        this.ids = in.readStringArray();
        this.externalIds = in.readStringArray();
        if (in.getTransportVersion().onOrAfter(TransportVersions.V_8_7_0)) {
            this.timeout = in.readTimeValue();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.names);
        out.writeStringArray(this.ids);
        out.writeStringArray(this.externalIds);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_7_0)) {
            out.writeTimeValue(this.timeout);
        }
    }

    @Override
    public ActionRequestValidationException validate() {
        List<String[]> nonEmptyParams = Stream.of(this.names, this.ids, this.externalIds).filter(a -> a != null && ((String[])a).length > 0).toList();
        if (nonEmptyParams.isEmpty()) {
            ActionRequestValidationException e = new ActionRequestValidationException();
            e.addValidationError(VALIDATION_ERROR_MSG_NO_QUERY_PARAM);
            return e;
        }
        if (nonEmptyParams.size() > 1) {
            ActionRequestValidationException e = new ActionRequestValidationException();
            e.addValidationError(VALIDATION_ERROR_MSG_ONLY_ONE_QUERY_PARAM);
            return e;
        }
        return null;
    }

    public String[] getNames() {
        return this.names;
    }

    public String[] getIds() {
        return this.ids;
    }

    public String[] getExternalIds() {
        return this.externalIds;
    }

    public TimeValue timeout() {
        return this.timeout;
    }

    public PrevalidateNodeRemovalRequest timeout(TimeValue timeout) {
        this.timeout = timeout;
        if (this.masterNodeTimeout == DEFAULT_MASTER_NODE_TIMEOUT) {
            this.masterNodeTimeout = timeout;
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PrevalidateNodeRemovalRequest)) {
            return false;
        }
        PrevalidateNodeRemovalRequest other = (PrevalidateNodeRemovalRequest)o;
        return Arrays.equals(this.names, other.names) && Arrays.equals(this.ids, other.ids) && Arrays.equals(this.externalIds, other.externalIds);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.names), Arrays.hashCode(this.ids), Arrays.hashCode(this.externalIds));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String[] names = Strings.EMPTY_ARRAY;
        private String[] ids = Strings.EMPTY_ARRAY;
        private String[] externalIds = Strings.EMPTY_ARRAY;

        public Builder setNames(String ... names) {
            Objects.requireNonNull(names);
            this.names = names;
            return this;
        }

        public Builder setIds(String ... ids) {
            Objects.requireNonNull(ids);
            this.ids = ids;
            return this;
        }

        public Builder setExternalIds(String ... externalIds) {
            Objects.requireNonNull(externalIds);
            this.externalIds = externalIds;
            return this;
        }

        public PrevalidateNodeRemovalRequest build() {
            return new PrevalidateNodeRemovalRequest(this);
        }
    }
}

