/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.logstash.filters.elasticintegration.geoip;

import co.elastic.logstash.filters.elasticintegration.geoip.GeoIpDatabaseAdapter;
import co.elastic.logstash.filters.elasticintegration.geoip.GeoipDatabaseHolder;
import java.io.Closeable;
import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.ingest.geoip.GeoIpDatabase;

public class ConstantGeoipDatabaseHolder
implements GeoipDatabaseHolder,
Closeable {
    private final GeoIpDatabaseAdapter geoipDatabase;

    public ConstantGeoipDatabaseHolder(GeoIpDatabaseAdapter geoipDatabase) {
        this.geoipDatabase = Objects.requireNonNull(geoipDatabase);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public GeoIpDatabase getDatabase() {
        return this.geoipDatabase;
    }

    @Override
    public String getTypeIdentifier() {
        return this.geoipDatabase.getDatabaseType();
    }

    @Override
    public String info() {
        return String.format("ConstantGeoipDatabase{type=%s}", this.getTypeIdentifier());
    }

    @Override
    public void close() throws IOException {
        IOUtils.closeWhileHandlingException((Closeable)this.geoipDatabase);
    }
}

