/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.json;

import jakarta.json.stream.JsonLocation;
import jakarta.json.stream.JsonParser;
import jakarta.json.stream.JsonParsingException;
import java.util.LinkedList;
import java.util.regex.Pattern;

public class JsonpMappingException
extends JsonParsingException {
    private final LinkedList<Object> path = new LinkedList();
    private Object ref;
    private static final Pattern identifier = Pattern.compile("[_a-zA-Z][_a-zA-Z0-9]*");

    public JsonpMappingException(String message, JsonLocation location) {
        super(message, location);
    }

    public JsonpMappingException(String message, Throwable cause, JsonLocation location) {
        super(message, cause, location);
    }

    public JsonpMappingException(Throwable cause, JsonLocation location) {
        super(cause.toString(), cause, location);
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder("Error deserializing");
        if (this.ref != null) {
            sb.append(' ');
            String className = this.ref.getClass().getName();
            if (className.endsWith("$Builder")) {
                sb.append(className, 0, className.length() - "$Builder".length());
            } else {
                sb.append(className);
            }
        }
        sb.append(": ").append(super.getMessage());
        if (!this.path.isEmpty()) {
            sb.append(" (JSON path: ");
            this.path(sb);
            sb.append(") ");
        }
        sb.append(this.getLocation());
        return sb.toString();
    }

    public String path() {
        StringBuilder sb = new StringBuilder();
        this.path(sb);
        return sb.toString();
    }

    void path(StringBuilder sb) {
        String sep = "";
        for (Object e : this.path) {
            if (e instanceof Integer) {
                sb.append("[").append((Integer)e).append("]");
            } else {
                String str = e.toString();
                if (identifier.matcher(str).matches()) {
                    sb.append(sep).append(e);
                } else {
                    sb.append("['").append(str).append("']");
                }
            }
            sep = ".";
        }
    }

    public JsonpMappingException prepend(Object ref, String name) {
        return this.prepend0(ref, name);
    }

    public JsonpMappingException prepend(Object ref, int idx) {
        return this.prepend0(ref, idx);
    }

    private JsonpMappingException prepend0(Object ref, Object pathItem) {
        if (pathItem != null) {
            this.path.addFirst(pathItem);
        }
        if (this.ref == null) {
            this.ref = ref;
        }
        return this;
    }

    public static JsonpMappingException from(Throwable cause, Object ref, String name, JsonParser parser) {
        return JsonpMappingException.from0(cause, ref, name, parser);
    }

    public static JsonpMappingException from(Throwable cause, int index, JsonParser parser) {
        return JsonpMappingException.from0(cause, null, index, parser);
    }

    private static JsonpMappingException from0(Throwable cause, Object ref, Object pathItem, JsonParser parser) {
        JsonpMappingException jme = cause instanceof JsonpMappingException ? (JsonpMappingException)cause : new JsonpMappingException(cause, parser.getLocation());
        return jme.prepend0(ref, pathItem);
    }
}

