/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.rollup;

import co.elastic.clients.elasticsearch._types.AcknowledgedResponse;
import co.elastic.clients.elasticsearch._types.TaskFailure;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DeleteJobResponse
implements AcknowledgedResponse,
JsonpSerializable {
    private final boolean acknowledged;
    private final List<TaskFailure> taskFailures;
    public static final JsonpDeserializer<DeleteJobResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DeleteJobResponse::setupDeleteJobResponseDeserializer);

    private DeleteJobResponse(Builder builder) {
        this.acknowledged = ApiTypeHelper.requireNonNull(builder.acknowledged, this, "acknowledged");
        this.taskFailures = ApiTypeHelper.unmodifiable(builder.taskFailures);
    }

    public static DeleteJobResponse of(Function<Builder, ObjectBuilder<DeleteJobResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public final boolean acknowledged() {
        return this.acknowledged;
    }

    public final List<TaskFailure> taskFailures() {
        return this.taskFailures;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("acknowledged");
        generator.write(this.acknowledged);
        if (ApiTypeHelper.isDefined(this.taskFailures)) {
            generator.writeKey("task_failures");
            generator.writeStartArray();
            for (TaskFailure item0 : this.taskFailures) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupDeleteJobResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::acknowledged, JsonpDeserializer.booleanDeserializer(), "acknowledged");
        op.add(Builder::taskFailures, JsonpDeserializer.arrayDeserializer(TaskFailure._DESERIALIZER), "task_failures");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DeleteJobResponse> {
        private Boolean acknowledged;
        @Nullable
        private List<TaskFailure> taskFailures;

        public final Builder acknowledged(boolean value) {
            this.acknowledged = value;
            return this;
        }

        public final Builder taskFailures(List<TaskFailure> list) {
            this.taskFailures = Builder._listAddAll(this.taskFailures, list);
            return this;
        }

        public final Builder taskFailures(TaskFailure value, TaskFailure ... values) {
            this.taskFailures = Builder._listAdd(this.taskFailures, value, values);
            return this;
        }

        public final Builder taskFailures(Function<TaskFailure.Builder, ObjectBuilder<TaskFailure>> fn) {
            return this.taskFailures(fn.apply(new TaskFailure.Builder()).build(), new TaskFailure[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DeleteJobResponse build() {
            this._checkSingleUse();
            return new DeleteJobResponse(this);
        }
    }
}

