/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.license.get;

import co.elastic.clients.elasticsearch.license.LicenseStatus;
import co.elastic.clients.elasticsearch.license.LicenseType;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.DateTime;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class LicenseInformation
implements JsonpSerializable {
    @Nullable
    private final DateTime expiryDate;
    @Nullable
    private final Long expiryDateInMillis;
    private final DateTime issueDate;
    private final long issueDateInMillis;
    private final String issuedTo;
    private final String issuer;
    @Nullable
    private final Long maxNodes;
    @Nullable
    private final Integer maxResourceUnits;
    private final LicenseStatus status;
    private final LicenseType type;
    private final String uid;
    private final long startDateInMillis;
    public static final JsonpDeserializer<LicenseInformation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, LicenseInformation::setupLicenseInformationDeserializer);

    private LicenseInformation(Builder builder) {
        this.expiryDate = builder.expiryDate;
        this.expiryDateInMillis = builder.expiryDateInMillis;
        this.issueDate = ApiTypeHelper.requireNonNull(builder.issueDate, this, "issueDate");
        this.issueDateInMillis = ApiTypeHelper.requireNonNull(builder.issueDateInMillis, this, "issueDateInMillis");
        this.issuedTo = ApiTypeHelper.requireNonNull(builder.issuedTo, this, "issuedTo");
        this.issuer = ApiTypeHelper.requireNonNull(builder.issuer, this, "issuer");
        this.maxNodes = builder.maxNodes;
        this.maxResourceUnits = builder.maxResourceUnits;
        this.status = ApiTypeHelper.requireNonNull(builder.status, this, "status");
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
        this.uid = ApiTypeHelper.requireNonNull(builder.uid, this, "uid");
        this.startDateInMillis = ApiTypeHelper.requireNonNull(builder.startDateInMillis, this, "startDateInMillis");
    }

    public static LicenseInformation of(Function<Builder, ObjectBuilder<LicenseInformation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final DateTime expiryDate() {
        return this.expiryDate;
    }

    @Nullable
    public final Long expiryDateInMillis() {
        return this.expiryDateInMillis;
    }

    public final DateTime issueDate() {
        return this.issueDate;
    }

    public final long issueDateInMillis() {
        return this.issueDateInMillis;
    }

    public final String issuedTo() {
        return this.issuedTo;
    }

    public final String issuer() {
        return this.issuer;
    }

    @Nullable
    public final Long maxNodes() {
        return this.maxNodes;
    }

    @Nullable
    public final Integer maxResourceUnits() {
        return this.maxResourceUnits;
    }

    public final LicenseStatus status() {
        return this.status;
    }

    public final LicenseType type() {
        return this.type;
    }

    public final String uid() {
        return this.uid;
    }

    public final long startDateInMillis() {
        return this.startDateInMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.expiryDate != null) {
            generator.writeKey("expiry_date");
            this.expiryDate.serialize(generator, mapper);
        }
        if (this.expiryDateInMillis != null) {
            generator.writeKey("expiry_date_in_millis");
            generator.write(this.expiryDateInMillis);
        }
        generator.writeKey("issue_date");
        this.issueDate.serialize(generator, mapper);
        generator.writeKey("issue_date_in_millis");
        generator.write(this.issueDateInMillis);
        generator.writeKey("issued_to");
        generator.write(this.issuedTo);
        generator.writeKey("issuer");
        generator.write(this.issuer);
        if (this.maxNodes != null) {
            generator.writeKey("max_nodes");
            generator.write(this.maxNodes);
        }
        if (this.maxResourceUnits != null) {
            generator.writeKey("max_resource_units");
            JsonpUtils.serializeIntOrNull(generator, this.maxResourceUnits, 0);
        }
        generator.writeKey("status");
        this.status.serialize(generator, mapper);
        generator.writeKey("type");
        this.type.serialize(generator, mapper);
        generator.writeKey("uid");
        generator.write(this.uid);
        generator.writeKey("start_date_in_millis");
        generator.write(this.startDateInMillis);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupLicenseInformationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::expiryDate, DateTime._DESERIALIZER, "expiry_date");
        op.add(Builder::expiryDateInMillis, JsonpDeserializer.longDeserializer(), "expiry_date_in_millis");
        op.add(Builder::issueDate, DateTime._DESERIALIZER, "issue_date");
        op.add(Builder::issueDateInMillis, JsonpDeserializer.longDeserializer(), "issue_date_in_millis");
        op.add(Builder::issuedTo, JsonpDeserializer.stringDeserializer(), "issued_to");
        op.add(Builder::issuer, JsonpDeserializer.stringDeserializer(), "issuer");
        op.add(Builder::maxNodes, JsonpDeserializer.longDeserializer(), "max_nodes");
        op.add(Builder::maxResourceUnits, JsonpDeserializer.intOrNullDeserializer(0), "max_resource_units");
        op.add(Builder::status, LicenseStatus._DESERIALIZER, "status");
        op.add(Builder::type, LicenseType._DESERIALIZER, "type");
        op.add(Builder::uid, JsonpDeserializer.stringDeserializer(), "uid");
        op.add(Builder::startDateInMillis, JsonpDeserializer.longDeserializer(), "start_date_in_millis");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<LicenseInformation> {
        @Nullable
        private DateTime expiryDate;
        @Nullable
        private Long expiryDateInMillis;
        private DateTime issueDate;
        private Long issueDateInMillis;
        private String issuedTo;
        private String issuer;
        @Nullable
        private Long maxNodes;
        @Nullable
        private Integer maxResourceUnits;
        private LicenseStatus status;
        private LicenseType type;
        private String uid;
        private Long startDateInMillis;

        public final Builder expiryDate(@Nullable DateTime value) {
            this.expiryDate = value;
            return this;
        }

        public final Builder expiryDateInMillis(@Nullable Long value) {
            this.expiryDateInMillis = value;
            return this;
        }

        public final Builder issueDate(DateTime value) {
            this.issueDate = value;
            return this;
        }

        public final Builder issueDateInMillis(long value) {
            this.issueDateInMillis = value;
            return this;
        }

        public final Builder issuedTo(String value) {
            this.issuedTo = value;
            return this;
        }

        public final Builder issuer(String value) {
            this.issuer = value;
            return this;
        }

        public final Builder maxNodes(@Nullable Long value) {
            this.maxNodes = value;
            return this;
        }

        public final Builder maxResourceUnits(@Nullable Integer value) {
            this.maxResourceUnits = value;
            return this;
        }

        public final Builder status(LicenseStatus value) {
            this.status = value;
            return this;
        }

        public final Builder type(LicenseType value) {
            this.type = value;
            return this;
        }

        public final Builder uid(String value) {
            this.uid = value;
            return this;
        }

        public final Builder startDateInMillis(long value) {
            this.startDateInMillis = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public LicenseInformation build() {
            this._checkSingleUse();
            return new LicenseInformation(this);
        }
    }
}

