/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.RankFeatureFunction;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class RankFeatureFunctionSigmoid
extends RankFeatureFunction
implements JsonpSerializable {
    private final float pivot;
    private final float exponent;
    public static final JsonpDeserializer<RankFeatureFunctionSigmoid> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RankFeatureFunctionSigmoid::setupRankFeatureFunctionSigmoidDeserializer);

    private RankFeatureFunctionSigmoid(Builder builder) {
        this.pivot = ApiTypeHelper.requireNonNull(builder.pivot, this, "pivot").floatValue();
        this.exponent = ApiTypeHelper.requireNonNull(builder.exponent, this, "exponent").floatValue();
    }

    public static RankFeatureFunctionSigmoid of(Function<Builder, ObjectBuilder<RankFeatureFunctionSigmoid>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final float pivot() {
        return this.pivot;
    }

    public final float exponent() {
        return this.exponent;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("pivot");
        generator.write(this.pivot);
        generator.writeKey("exponent");
        generator.write(this.exponent);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupRankFeatureFunctionSigmoidDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::pivot, JsonpDeserializer.floatDeserializer(), "pivot");
        op.add(Builder::exponent, JsonpDeserializer.floatDeserializer(), "exponent");
    }

    public static class Builder
    extends RankFeatureFunction.AbstractBuilder<Builder>
    implements ObjectBuilder<RankFeatureFunctionSigmoid> {
        private Float pivot;
        private Float exponent;

        public final Builder pivot(float value) {
            this.pivot = Float.valueOf(value);
            return this;
        }

        public final Builder exponent(float value) {
            this.exponent = Float.valueOf(value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RankFeatureFunctionSigmoid build() {
            this._checkSingleUse();
            return new RankFeatureFunctionSigmoid(this);
        }
    }
}

