/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationBase;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.CategorizeTextAnalyzer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class CategorizeTextAggregation
extends AggregationBase
implements AggregationVariant {
    private final String field;
    @Nullable
    private final Integer maxUniqueTokens;
    @Nullable
    private final Integer maxMatchedTokens;
    @Nullable
    private final Integer similarityThreshold;
    private final List<String> categorizationFilters;
    @Nullable
    private final CategorizeTextAnalyzer categorizationAnalyzer;
    @Nullable
    private final Integer shardSize;
    @Nullable
    private final Integer size;
    @Nullable
    private final Integer minDocCount;
    @Nullable
    private final Integer shardMinDocCount;
    public static final JsonpDeserializer<CategorizeTextAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CategorizeTextAggregation::setupCategorizeTextAggregationDeserializer);

    private CategorizeTextAggregation(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.maxUniqueTokens = builder.maxUniqueTokens;
        this.maxMatchedTokens = builder.maxMatchedTokens;
        this.similarityThreshold = builder.similarityThreshold;
        this.categorizationFilters = ApiTypeHelper.unmodifiable(builder.categorizationFilters);
        this.categorizationAnalyzer = builder.categorizationAnalyzer;
        this.shardSize = builder.shardSize;
        this.size = builder.size;
        this.minDocCount = builder.minDocCount;
        this.shardMinDocCount = builder.shardMinDocCount;
    }

    public static CategorizeTextAggregation of(Function<Builder, ObjectBuilder<CategorizeTextAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.CategorizeText;
    }

    public final String field() {
        return this.field;
    }

    @Nullable
    public final Integer maxUniqueTokens() {
        return this.maxUniqueTokens;
    }

    @Nullable
    public final Integer maxMatchedTokens() {
        return this.maxMatchedTokens;
    }

    @Nullable
    public final Integer similarityThreshold() {
        return this.similarityThreshold;
    }

    public final List<String> categorizationFilters() {
        return this.categorizationFilters;
    }

    @Nullable
    public final CategorizeTextAnalyzer categorizationAnalyzer() {
        return this.categorizationAnalyzer;
    }

    @Nullable
    public final Integer shardSize() {
        return this.shardSize;
    }

    @Nullable
    public final Integer size() {
        return this.size;
    }

    @Nullable
    public final Integer minDocCount() {
        return this.minDocCount;
    }

    @Nullable
    public final Integer shardMinDocCount() {
        return this.shardMinDocCount;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("field");
        generator.write(this.field);
        if (this.maxUniqueTokens != null) {
            generator.writeKey("max_unique_tokens");
            generator.write(this.maxUniqueTokens);
        }
        if (this.maxMatchedTokens != null) {
            generator.writeKey("max_matched_tokens");
            generator.write(this.maxMatchedTokens);
        }
        if (this.similarityThreshold != null) {
            generator.writeKey("similarity_threshold");
            generator.write(this.similarityThreshold);
        }
        if (ApiTypeHelper.isDefined(this.categorizationFilters)) {
            generator.writeKey("categorization_filters");
            generator.writeStartArray();
            for (String item0 : this.categorizationFilters) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.categorizationAnalyzer != null) {
            generator.writeKey("categorization_analyzer");
            this.categorizationAnalyzer.serialize(generator, mapper);
        }
        if (this.shardSize != null) {
            generator.writeKey("shard_size");
            generator.write(this.shardSize);
        }
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size);
        }
        if (this.minDocCount != null) {
            generator.writeKey("min_doc_count");
            generator.write(this.minDocCount);
        }
        if (this.shardMinDocCount != null) {
            generator.writeKey("shard_min_doc_count");
            generator.write(this.shardMinDocCount);
        }
    }

    protected static void setupCategorizeTextAggregationDeserializer(ObjectDeserializer<Builder> op) {
        AggregationBase.setupAggregationBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::maxUniqueTokens, JsonpDeserializer.integerDeserializer(), "max_unique_tokens");
        op.add(Builder::maxMatchedTokens, JsonpDeserializer.integerDeserializer(), "max_matched_tokens");
        op.add(Builder::similarityThreshold, JsonpDeserializer.integerDeserializer(), "similarity_threshold");
        op.add(Builder::categorizationFilters, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "categorization_filters");
        op.add(Builder::categorizationAnalyzer, CategorizeTextAnalyzer._DESERIALIZER, "categorization_analyzer");
        op.add(Builder::shardSize, JsonpDeserializer.integerDeserializer(), "shard_size");
        op.add(Builder::size, JsonpDeserializer.integerDeserializer(), "size");
        op.add(Builder::minDocCount, JsonpDeserializer.integerDeserializer(), "min_doc_count");
        op.add(Builder::shardMinDocCount, JsonpDeserializer.integerDeserializer(), "shard_min_doc_count");
    }

    public static class Builder
    extends AggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<CategorizeTextAggregation> {
        private String field;
        @Nullable
        private Integer maxUniqueTokens;
        @Nullable
        private Integer maxMatchedTokens;
        @Nullable
        private Integer similarityThreshold;
        @Nullable
        private List<String> categorizationFilters;
        @Nullable
        private CategorizeTextAnalyzer categorizationAnalyzer;
        @Nullable
        private Integer shardSize;
        @Nullable
        private Integer size;
        @Nullable
        private Integer minDocCount;
        @Nullable
        private Integer shardMinDocCount;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder maxUniqueTokens(@Nullable Integer value) {
            this.maxUniqueTokens = value;
            return this;
        }

        public final Builder maxMatchedTokens(@Nullable Integer value) {
            this.maxMatchedTokens = value;
            return this;
        }

        public final Builder similarityThreshold(@Nullable Integer value) {
            this.similarityThreshold = value;
            return this;
        }

        public final Builder categorizationFilters(List<String> list) {
            this.categorizationFilters = Builder._listAddAll(this.categorizationFilters, list);
            return this;
        }

        public final Builder categorizationFilters(String value, String ... values) {
            this.categorizationFilters = Builder._listAdd(this.categorizationFilters, value, values);
            return this;
        }

        public final Builder categorizationAnalyzer(@Nullable CategorizeTextAnalyzer value) {
            this.categorizationAnalyzer = value;
            return this;
        }

        public final Builder categorizationAnalyzer(Function<CategorizeTextAnalyzer.Builder, ObjectBuilder<CategorizeTextAnalyzer>> fn) {
            return this.categorizationAnalyzer(fn.apply(new CategorizeTextAnalyzer.Builder()).build());
        }

        public final Builder shardSize(@Nullable Integer value) {
            this.shardSize = value;
            return this;
        }

        public final Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        public final Builder minDocCount(@Nullable Integer value) {
            this.minDocCount = value;
            return this;
        }

        public final Builder shardMinDocCount(@Nullable Integer value) {
            this.shardMinDocCount = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CategorizeTextAggregation build() {
            this._checkSingleUse();
            return new CategorizeTextAggregation(this);
        }
    }
}

