/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.xact;

import org.apache.derby.iapi.services.locks.LockFactory;
import org.apache.derby.iapi.store.raw.ContainerHandle;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.store.raw.RowLock;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.impl.store.raw.xact.RowLocking3;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public class RowLockingRR
extends RowLocking3 {
    protected RowLockingRR(LockFactory lf) {
        super(lf);
    }

    @Override
    protected RowLock getReadLockType() {
        return RowLock.RS2;
    }

    @Override
    protected RowLock getUpdateLockType() {
        return RowLock.RU2;
    }

    @Override
    protected RowLock getWriteLockType() {
        return RowLock.RX2;
    }

    @Override
    public void unlockRecordAfterRead(Transaction t, ContainerHandle container_handle, RecordHandle record, boolean forUpdate, boolean row_qualified) throws StandardException {
        if (!row_qualified) {
            RowLock qualifier = forUpdate ? RowLock.RU2 : RowLock.RS2;
            int count = this.lf.unlock(t.getCompatibilitySpace(), t, record, qualifier);
            if (count != 1 && count != 0) {
                SanityManager.THROWASSERT((String)("count = " + count + "record.getContainerId() = " + record.getContainerId()));
            }
        }
    }
}

