/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.jruby;

import java.util.HashMap;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class ExtensionRegistry {
    private final Map<RubyModule, ExtensionEntry> extensionsByModule;
    private final Map<RubyModule, ExtensionEntry> extensionsByAncestor;
    private final ExtensionEntry[] extensionsByTypeId;

    public ExtensionRegistry() {
        this(new HashMap<RubyModule, ExtensionEntry>(), new ExtensionEntry[256]);
    }

    private ExtensionRegistry(Map<RubyModule, ExtensionEntry> map, ExtensionEntry[] extensionEntryArray) {
        this.extensionsByModule = new HashMap<RubyModule, ExtensionEntry>(map);
        this.extensionsByAncestor = new HashMap<RubyModule, ExtensionEntry>();
        this.extensionsByTypeId = (ExtensionEntry[])extensionEntryArray.clone();
    }

    public ExtensionRegistry dup() {
        return new ExtensionRegistry(this.extensionsByModule, this.extensionsByTypeId);
    }

    public IRubyObject toInternalPackerRegistry(ThreadContext threadContext) {
        RubyHash rubyHash = RubyHash.newHash((Ruby)threadContext.runtime);
        for (RubyModule rubyModule : this.extensionsByModule.keySet()) {
            ExtensionEntry extensionEntry = this.extensionsByModule.get(rubyModule);
            if (!extensionEntry.hasPacker()) continue;
            rubyHash.put((Object)rubyModule, extensionEntry.toPackerTuple(threadContext));
        }
        return rubyHash;
    }

    public IRubyObject toInternalUnpackerRegistry(ThreadContext threadContext) {
        RubyHash rubyHash = RubyHash.newHash((Ruby)threadContext.runtime);
        for (int i = 0; i < 256; ++i) {
            ExtensionEntry extensionEntry = this.extensionsByTypeId[i];
            if (extensionEntry == null || !extensionEntry.hasUnpacker()) continue;
            RubyFixnum rubyFixnum = RubyFixnum.newFixnum((Ruby)threadContext.runtime, (long)(i - 128));
            rubyHash.put((Object)rubyFixnum, extensionEntry.toUnpackerTuple(threadContext));
        }
        return rubyHash;
    }

    public void put(RubyModule rubyModule, int n, boolean bl, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        ExtensionEntry extensionEntry = new ExtensionEntry(rubyModule, n, bl, iRubyObject, iRubyObject2);
        this.extensionsByModule.put(rubyModule, extensionEntry);
        this.extensionsByTypeId[n + 128] = extensionEntry;
        this.extensionsByAncestor.clear();
    }

    public ExtensionEntry lookupExtensionByTypeId(int n) {
        ExtensionEntry extensionEntry = this.extensionsByTypeId[n + 128];
        if (extensionEntry != null && extensionEntry.hasUnpacker()) {
            return extensionEntry;
        }
        return null;
    }

    public ExtensionEntry lookupExtensionForObject(IRubyObject iRubyObject) {
        RubyClass rubyClass = null;
        ExtensionEntry extensionEntry = null;
        rubyClass = iRubyObject.getMetaClass();
        extensionEntry = this.extensionsByModule.get(rubyClass);
        if (extensionEntry != null && extensionEntry.hasPacker()) {
            return extensionEntry;
        }
        RubyClass rubyClass2 = iRubyObject.getType();
        if (rubyClass2 != rubyClass && (extensionEntry = this.extensionsByModule.get(rubyClass2)) != null && extensionEntry.hasPacker()) {
            return extensionEntry;
        }
        extensionEntry = this.findEntryByModuleOrAncestor((RubyModule)rubyClass);
        if (extensionEntry != null && extensionEntry.hasPacker()) {
            return extensionEntry;
        }
        return null;
    }

    private ExtensionEntry findEntryByModuleOrAncestor(RubyModule rubyModule) {
        ThreadContext threadContext = rubyModule.getRuntime().getCurrentContext();
        for (RubyModule rubyModule2 : this.extensionsByModule.keySet()) {
            RubyArray rubyArray = (RubyArray)rubyModule.callMethod(threadContext, "ancestors");
            if (!rubyArray.callMethod(threadContext, "include?", (IRubyObject)rubyModule2).isTrue()) continue;
            return this.extensionsByModule.get(rubyModule2);
        }
        return null;
    }

    public static class ExtensionEntry {
        private final RubyModule mod;
        private final int typeId;
        private final boolean recursive;
        private final IRubyObject packerProc;
        private final IRubyObject unpackerProc;

        public ExtensionEntry(RubyModule rubyModule, int n, boolean bl, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            this.mod = rubyModule;
            this.typeId = n;
            this.recursive = bl;
            this.packerProc = iRubyObject;
            this.unpackerProc = iRubyObject2;
        }

        public RubyModule getExtensionModule() {
            return this.mod;
        }

        public int getTypeId() {
            return this.typeId;
        }

        public boolean isRecursive() {
            return this.recursive;
        }

        public boolean hasPacker() {
            return this.packerProc != null && !this.packerProc.isNil();
        }

        public boolean hasUnpacker() {
            return this.unpackerProc != null && !this.unpackerProc.isNil();
        }

        public IRubyObject getPackerProc() {
            return this.packerProc;
        }

        public IRubyObject getUnpackerProc() {
            return this.unpackerProc;
        }

        public RubyArray<?> toPackerTuple(ThreadContext threadContext) {
            return threadContext.runtime.newArray(new IRubyObject[]{threadContext.runtime.newFixnum(this.typeId), this.packerProc});
        }

        public RubyArray<?> toUnpackerTuple(ThreadContext threadContext) {
            return threadContext.runtime.newArray(new IRubyObject[]{this.mod, this.unpackerProc});
        }

        public IRubyObject[] toPackerProcTypeIdPair(ThreadContext threadContext) {
            return new IRubyObject[]{this.packerProc, threadContext.runtime.newFixnum(this.typeId)};
        }
    }
}

