/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.log;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.io.SegmentedStringWriter;
import com.fasterxml.jackson.core.util.BufferRecycler;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.google.common.primitives.Primitives;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.logstash.ObjectMappers;
import org.logstash.log.CustomLogEvent;
import org.logstash.log.StructuredMessage;

public class CustomLogEventSerializer
extends JsonSerializer<CustomLogEvent> {
    private static final Logger LOGGER = LogManager.getLogger(CustomLogEventSerializer.class);

    public void serialize(CustomLogEvent event, JsonGenerator generator, SerializerProvider provider) throws IOException {
        generator.writeStartObject();
        generator.writeObjectField("level", (Object)event.getLevel());
        generator.writeObjectField("loggerName", (Object)event.getLoggerName());
        generator.writeObjectField("timeMillis", (Object)event.getTimeMillis());
        generator.writeObjectField("thread", (Object)event.getThreadName());
        generator.writeFieldName("logEvent");
        generator.writeStartObject();
        if (event.getMessage() instanceof StructuredMessage) {
            this.writeStructuredMessage((StructuredMessage)event.getMessage(), generator);
        } else {
            generator.writeStringField("message", event.getMessage().getFormattedMessage());
        }
        generator.writeEndObject();
        generator.writeEndObject();
    }

    private void writeStructuredMessage(StructuredMessage message, JsonGenerator generator) throws IOException {
        generator.writeStringField("message", message.getMessage());
        if (message.getParams() == null || message.getParams().isEmpty()) {
            return;
        }
        for (Map.Entry<Object, Object> entry : message.getParams().entrySet()) {
            String paramName = entry.getKey().toString();
            Object paramValue = entry.getValue();
            try {
                if (this.isValueSafeToWrite(paramValue)) {
                    generator.writeObjectField(paramName, paramValue);
                    continue;
                }
                try (SegmentedStringWriter entryJsonWriter = new SegmentedStringWriter(new BufferRecycler());){
                    JsonGenerator entryGenerator = ObjectMappers.LOG4J_JSON_MAPPER.getFactory().createGenerator((Writer)entryJsonWriter);
                    try {
                        entryGenerator.writeObject(paramValue);
                        generator.writeFieldName(paramName);
                        generator.writeRawValue(entryJsonWriter.getAndClear());
                    }
                    finally {
                        if (entryGenerator == null) continue;
                        entryGenerator.close();
                    }
                }
            }
            catch (JsonMappingException e) {
                LOGGER.debug("Failed to serialize message param type {}", paramValue.getClass(), (Object)e);
                generator.writeObjectField(paramName, (Object)paramValue.toString());
            }
        }
    }

    private boolean isValueSafeToWrite(Object value) {
        return value == null || value instanceof String || value.getClass().isPrimitive() || Primitives.isWrapperType(value.getClass());
    }

    public Class<CustomLogEvent> handledType() {
        return CustomLogEvent.class;
    }
}

