/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.Count;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.LazySequence;
import net.sf.saxon.om.MemoSequence;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.GroundedIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.wrapper.VirtualNode;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.HexBinaryValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SequenceExtent;

public class SequenceTool {
    public static final int INDETERMINATE_ORDERING = Integer.MIN_VALUE;

    public static GroundedValue toGroundedValue(Sequence sequence) throws XPathException {
        if (sequence instanceof GroundedValue) {
            return (GroundedValue)sequence;
        }
        return SequenceExtent.makeSequenceExtent(sequence.iterate());
    }

    public static GroundedValue toGroundedValue(SequenceIterator iterator) throws XPathException {
        if ((iterator.getProperties() & 1) != 0) {
            return ((GroundedIterator)iterator).materialize();
        }
        return SequenceExtent.makeSequenceExtent(iterator);
    }

    public static Sequence toMemoSequence(SequenceIterator iterator) throws XPathException {
        if ((iterator.getProperties() & 1) != 0) {
            return ((GroundedIterator)iterator).materialize();
        }
        return new MemoSequence(iterator);
    }

    public static Sequence toLazySequence(SequenceIterator iterator) throws XPathException {
        if ((iterator.getProperties() & 1) != 0) {
            return ((GroundedIterator)iterator).materialize();
        }
        return new LazySequence(iterator);
    }

    public static int getLength(Sequence sequence) throws XPathException {
        if (sequence instanceof Item) {
            return 1;
        }
        if (sequence instanceof GroundedValue) {
            return ((GroundedValue)sequence).getLength();
        }
        return Count.count(sequence.iterate());
    }

    public static Item itemAt(Sequence sequence, int index) throws XPathException {
        if (sequence instanceof Item && index == 0) {
            return (Item)sequence;
        }
        return SequenceTool.toGroundedValue(sequence).itemAt(index);
    }

    public static Item asItem(Sequence sequence) throws XPathException {
        if (sequence instanceof Item) {
            return (Item)sequence;
        }
        SequenceIterator iter = sequence.iterate();
        Item first = iter.next();
        if (first == null) {
            return null;
        }
        if (iter.next() != null) {
            throw new XPathException("Sequence contains more than one item");
        }
        return first;
    }

    public static Object convertToJava(Item item) throws XPathException {
        if (item instanceof NodeInfo) {
            Object node = item;
            while (node instanceof VirtualNode) {
                node = ((VirtualNode)node).getRealNode();
            }
            return node;
        }
        if (item instanceof FunctionItem) {
            return item;
        }
        if (item instanceof ObjectValue) {
            return ((ObjectValue)item).getObject();
        }
        AtomicValue value = (AtomicValue)item;
        switch (value.getItemType().getPrimitiveType()) {
            case 513: 
            case 518: 
            case 529: 
            case 631: {
                return value.getStringValue();
            }
            case 514: {
                return ((BooleanValue)value).getBooleanValue() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 515: {
                return ((DecimalValue)value).getDecimalValue();
            }
            case 533: {
                return ((NumericValue)value).longValue();
            }
            case 517: {
                return ((DoubleValue)value).getDoubleValue();
            }
            case 516: {
                return Float.valueOf(((FloatValue)value).getFloatValue());
            }
            case 519: {
                return ((DateTimeValue)value).getCalendar().getTime();
            }
            case 521: {
                return ((DateValue)value).getCalendar().getTime();
            }
            case 520: {
                return value.getStringValue();
            }
            case 528: {
                return ((Base64BinaryValue)value).getBinaryValue();
            }
            case 527: {
                return ((HexBinaryValue)value).getBinaryValue();
            }
        }
        return item;
    }

    public static String getStringValue(Sequence sequence) throws XPathException {
        Item item;
        FastStringBuffer fsb = new FastStringBuffer(64);
        SequenceIterator iter = sequence.iterate();
        boolean first = true;
        while ((item = iter.next()) != null) {
            if (first) {
                first = false;
            } else {
                fsb.append(' ');
            }
            fsb.append(item.getStringValueCS());
        }
        return fsb.toString();
    }

    public static ItemType getItemType(Sequence sequence, TypeHierarchy th) {
        if (sequence instanceof Item) {
            return Type.getItemType((Item)sequence, th);
        }
        if (sequence instanceof GroundedValue) {
            try {
                Item item;
                ItemType type = null;
                SequenceIterator iter = sequence.iterate();
                while ((item = iter.next()) != null && (type = type == null ? Type.getItemType(item, th) : Type.getCommonSuperType(type, Type.getItemType(item, th), th)) != AnyItemType.getInstance()) {
                }
                return type == null ? ErrorType.getInstance() : type;
            }
            catch (XPathException err) {
                return AnyItemType.getInstance();
            }
        }
        return AnyItemType.getInstance();
    }

    public static int getCardinality(Sequence sequence) {
        if (sequence instanceof Item) {
            return 16384;
        }
        if (sequence instanceof GroundedValue) {
            int len = ((GroundedValue)sequence).getLength();
            switch (len) {
                case 0: {
                    return 8192;
                }
                case 1: {
                    return 16384;
                }
            }
            return 49152;
        }
        try {
            SequenceIterator iter = sequence.iterate();
            Item item = iter.next();
            if (item == null) {
                return 8192;
            }
            item = iter.next();
            return item == null ? 16384 : 49152;
        }
        catch (XPathException err) {
            return 49152;
        }
    }

    public static void process(Sequence value, XPathContext context, int locationId) throws XPathException {
        Item it;
        SequenceIterator iter = value.iterate();
        SequenceReceiver out = context.getReceiver();
        while ((it = iter.next()) != null) {
            out.append(it, locationId, 2);
        }
    }
}

