/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rules;

import com.fasterxml.jackson.databind.JsonNode;
import io.confluent.kafka.schemaregistry.rules.RuleAction;
import io.confluent.kafka.schemaregistry.rules.RuleContext;
import io.confluent.kafka.schemaregistry.rules.RuleException;
import io.confluent.kafka.schemaregistry.utils.JacksonMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.errors.SerializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlqAction
implements RuleAction {
    private static final Logger log = LoggerFactory.getLogger(DlqAction.class);
    public static final String TYPE = "DLQ";
    public static final String TOPIC = "topic";
    public static final String PRODUCER = "producer";
    private String topic;
    private KafkaProducer<byte[], byte[]> producer;

    @Override
    public void configure(Map<String, ?> configs) {
        KafkaProducer producer;
        this.topic = (String)configs.get(TOPIC);
        if (this.topic == null || this.topic.isEmpty()) {
            log.warn("DLQ topic is missing");
        }
        if ((producer = (KafkaProducer)configs.get(PRODUCER)) == null) {
            Map<String, Object> producerConfigs = DlqAction.baseProducerConfigs();
            producerConfigs.putAll(configs);
            producer = new KafkaProducer(producerConfigs);
        }
        this.producer = producer;
    }

    @Override
    public String type() {
        return TYPE;
    }

    @Override
    public void run(RuleContext ctx, Object message, RuleException ex) throws RuleException {
        if (this.topic == null || this.topic.isEmpty()) {
            return;
        }
        try {
            byte[] keyBytes = this.convertToBytes(ctx, ctx.originalKey());
            byte[] valueBytes = this.convertToBytes(ctx, ctx.originalValue());
            ProducerRecord producerRecord = new ProducerRecord(this.topic, null, (Object)keyBytes, (Object)valueBytes, (Iterable)ctx.headers());
            this.producer.send(producerRecord, (metadata, exception) -> {
                if (exception != null) {
                    log.error("Could not produce message to dlq topic " + this.topic, (Throwable)exception);
                } else {
                    log.info("Sent message to dlq topic " + this.topic);
                }
            });
        }
        catch (IOException e) {
            log.error("Could not produce message to dlq topic " + this.topic, (Throwable)e);
        }
        String msg = "Rule failed: " + ctx.rule().getName();
        throw ex != null ? new SerializationException(msg, (Throwable)ex) : new SerializationException(msg);
    }

    private byte[] convertToBytes(RuleContext ctx, Object message) throws IOException {
        if (message == null) {
            return null;
        }
        if (message instanceof byte[]) {
            return (byte[])message;
        }
        JsonNode json = ctx.target().toJson(message);
        return JacksonMapper.INSTANCE.writeValueAsBytes((Object)json);
    }

    static Map<String, Object> baseProducerConfigs() {
        HashMap<String, Object> producerProps = new HashMap<String, Object>();
        producerProps.put("key.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        producerProps.put("value.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        producerProps.put("max.block.ms", Long.toString(Long.MAX_VALUE));
        producerProps.put("enable.idempotence", "false");
        producerProps.put("acks", "all");
        producerProps.put("max.in.flight.requests.per.connection", "1");
        producerProps.put("delivery.timeout.ms", Integer.toString(Integer.MAX_VALUE));
        return producerProps;
    }

    @Override
    public void close() {
        this.producer.close();
    }
}

