/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry;

import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.SchemaValidationStrategy;
import io.confluent.kafka.schemaregistry.SchemaValidator;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class SchemaValidatorBuilder {
    private SchemaValidationStrategy strategy;
    private static final String NEW_PREFIX = "new";
    private static final String OLD_PREFIX = "old";
    private static int MAX_SCHEMA_SIZE_FOR_LOGGING = 10240;

    public SchemaValidatorBuilder canReadStrategy() {
        this.strategy = (toValidate, existing) -> this.formatErrorMessages(toValidate.isBackwardCompatible(existing), existing, NEW_PREFIX, OLD_PREFIX, true);
        return this;
    }

    public SchemaValidatorBuilder canBeReadStrategy() {
        this.strategy = (toValidate, existing) -> this.formatErrorMessages(existing.isBackwardCompatible(toValidate), existing, OLD_PREFIX, NEW_PREFIX, true);
        return this;
    }

    public SchemaValidatorBuilder mutualReadStrategy() {
        this.strategy = (toValidate, existing) -> {
            List<String> result = this.formatErrorMessages(existing.isBackwardCompatible(toValidate), existing, OLD_PREFIX, NEW_PREFIX, false);
            result.addAll(this.formatErrorMessages(toValidate.isBackwardCompatible(existing), existing, NEW_PREFIX, OLD_PREFIX, true));
            return result;
        };
        return this;
    }

    public SchemaValidator validateLatest() {
        this.valid();
        return (toValidate, schemasInOrder) -> {
            Iterator schemas = schemasInOrder.iterator();
            if (schemas.hasNext()) {
                ParsedSchema existing = (ParsedSchema)schemas.next();
                return this.strategy.validate(toValidate, existing);
            }
            return Collections.emptyList();
        };
    }

    public SchemaValidator validateAll() {
        this.valid();
        return (toValidate, schemasInOrder) -> {
            for (ParsedSchema existing : schemasInOrder) {
                List<String> errorMessages = this.strategy.validate(toValidate, existing);
                if (errorMessages.isEmpty()) continue;
                return errorMessages;
            }
            return Collections.emptyList();
        };
    }

    private void valid() {
        if (null == this.strategy) {
            throw new RuntimeException("SchemaValidationStrategy not specified in builder");
        }
    }

    private List<String> formatErrorMessages(List<String> messages, ParsedSchema existing, String reader, String writer, boolean appendSchema) {
        if (messages.size() > 0) {
            messages.replaceAll(e -> String.format(e, reader, writer));
            if (appendSchema) {
                if (existing.version() != null) {
                    messages.add("{oldSchemaVersion: " + existing.version() + "}");
                }
                if (existing.toString().length() <= MAX_SCHEMA_SIZE_FOR_LOGGING) {
                    messages.add("{oldSchema: '" + existing + "'}");
                } else {
                    messages.add("{oldSchema: <truncated> '" + existing.toString().substring(0, MAX_SCHEMA_SIZE_FOR_LOGGING) + "...'}");
                }
            }
        }
        return messages;
    }
}

