/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.common;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.RubyUtil;

@JRubyClass(name={"BufferedTokenizer"})
public class BufferedTokenizerExt
extends RubyObject {
    private static final long serialVersionUID = 1L;
    private static final RubyString NEW_LINE = (RubyString)RubyUtil.RUBY.newString("\n").freeze(RubyUtil.RUBY.getCurrentContext());
    private RubyArray input = RubyUtil.RUBY.newArray();
    private RubyString delimiter = NEW_LINE;
    private int sizeLimit;
    private boolean hasSizeLimit;
    private int inputSize;

    public BufferedTokenizerExt(Ruby runtime, RubyClass metaClass) {
        super(runtime, metaClass);
    }

    @JRubyMethod(name={"initialize"}, optional=2)
    public IRubyObject init(ThreadContext context, IRubyObject[] args) {
        if (args.length >= 1) {
            this.delimiter = args[0].convertToString();
        }
        if (args.length == 2) {
            this.sizeLimit = args[1].convertToInteger().getIntValue();
            this.hasSizeLimit = true;
        }
        this.inputSize = 0;
        return this;
    }

    @JRubyMethod
    public RubyArray extract(ThreadContext context, IRubyObject data) {
        RubyArray entities = data.convertToString().split(this.delimiter, -1);
        if (this.hasSizeLimit) {
            int entitiesSize = ((RubyString)entities.first()).size();
            if (this.inputSize + entitiesSize > this.sizeLimit) {
                throw new IllegalStateException("input buffer full");
            }
            this.inputSize += entitiesSize;
        }
        this.input.append(entities.shift(context));
        if (entities.isEmpty()) {
            return RubyUtil.RUBY.newArray();
        }
        entities.unshift(this.input.join(context));
        this.input.clear();
        this.input.append(entities.pop(context));
        this.inputSize = ((RubyString)this.input.first()).size();
        return entities;
    }

    @JRubyMethod
    public IRubyObject flush(ThreadContext context) {
        IRubyObject buffer = this.input.join(context);
        this.input.clear();
        return buffer;
    }

    @JRubyMethod(name={"empty?"})
    public IRubyObject isEmpty(ThreadContext context) {
        return this.input.empty_p();
    }
}

